/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockInfusedWood
extends Block
implements BlockCustomName,
BlockVariants {
    public static PropertyEnum<WoodType> WOOD_TYPE = PropertyEnum.func_177709_a((String)"woodtype", WoodType.class);

    public BlockInfusedWood() {
        super(Material.field_151575_d, MapColor.field_151650_B);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149752_b(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.RAW)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (WoodType t : WoodType.values()) {
            if (!t.obtainableInCreative()) continue;
            list.add((Object)new ItemStack((Block)this, 1, t.getMeta()));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((WoodType)((Object)state.func_177229_b(WOOD_TYPE))).isColumn()) {
            IBlockState st = worldIn.func_180495_p(pos.func_177984_a());
            boolean top = false;
            if (st.func_177230_c() instanceof BlockInfusedWood && ((WoodType)((Object)st.func_177229_b(WOOD_TYPE))).isColumn()) {
                top = true;
            }
            st = worldIn.func_180495_p(pos.func_177977_b());
            boolean down = false;
            if (st.func_177230_c() instanceof BlockInfusedWood && ((WoodType)((Object)st.func_177229_b(WOOD_TYPE))).isColumn()) {
                down = true;
            }
            if (top && down) {
                return state.func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.COLUMN));
            }
            if (top) {
                return state.func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.COLUMN_BOTTOM));
            }
            if (down) {
                return state.func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.COLUMN_TOP));
            }
            return state.func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.COLUMN));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return ((WoodType)((Object)p_193383_2_.func_177229_b(WOOD_TYPE))).isColumn() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        WoodType woodType = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        if (woodType == WoodType.COLUMN_TOP || woodType == WoodType.COLUMN || woodType == WoodType.COLUMN_BOTTOM) {
            return 0;
        }
        return super.getLightOpacity(state, world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        WoodType woodType = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        return woodType != WoodType.COLUMN && woodType != WoodType.COLUMN_BOTTOM && woodType != WoodType.COLUMN_TOP;
    }

    public boolean func_149686_d(IBlockState state) {
        WoodType woodType = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        return woodType != WoodType.COLUMN && woodType != WoodType.COLUMN_BOTTOM && woodType != WoodType.COLUMN_TOP;
    }

    public boolean func_149730_j(IBlockState state) {
        WoodType woodType = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        return woodType != WoodType.COLUMN && woodType != WoodType.COLUMN_BOTTOM && woodType != WoodType.COLUMN_TOP;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        WoodType woodType = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        IBlockState other = world.func_180495_p(pos.func_177972_a(face));
        if ((other.func_177230_c() instanceof BlockLiquid || other.func_177230_c() instanceof BlockFluidBase) && (woodType == WoodType.COLUMN || woodType == WoodType.COLUMN_BOTTOM || woodType == WoodType.COLUMN_TOP)) {
            return false;
        }
        if (woodType == WoodType.COLUMN_TOP) {
            return face == EnumFacing.UP;
        }
        if (woodType == WoodType.COLUMN_BOTTOM) {
            return face == EnumFacing.DOWN;
        }
        return state.func_185914_p();
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        WoodType mt = (WoodType)((Object)this.func_176203_a(meta).func_177229_b(WOOD_TYPE));
        return mt.func_176610_l();
    }

    public int func_176201_c(IBlockState state) {
        WoodType type = (WoodType)((Object)state.func_177229_b(WOOD_TYPE));
        return type.getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return meta < WoodType.values().length ? this.func_176223_P().func_177226_a(WOOD_TYPE, (Comparable)((Object)WoodType.values()[meta])) : this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WOOD_TYPE});
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (WoodType type : WoodType.values()) {
            ret.add(this.func_176223_P().func_177226_a(WOOD_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((WoodType)((Object)state.func_177229_b(WOOD_TYPE))).func_176610_l();
    }

    public static enum WoodType implements IStringSerializable
    {
        RAW(0),
        PLANKS(1),
        COLUMN(2),
        ARCH(3),
        ENGRAVED(4),
        ENRICHED(5),
        INFUSED(6),
        COLUMN_TOP(2),
        COLUMN_BOTTOM(2);

        private final int meta;

        private WoodType(int meta) {
            this.meta = meta;
        }

        public ItemStack asStack() {
            return new ItemStack((Block)BlocksAS.blockInfusedWood, 1, this.meta);
        }

        public IBlockState asBlock() {
            return BlocksAS.blockInfusedWood.func_176203_a(this.meta);
        }

        public boolean isColumn() {
            return this == COLUMN_BOTTOM || this == COLUMN || this == COLUMN_TOP;
        }

        public boolean obtainableInCreative() {
            return this != COLUMN_TOP && this != COLUMN_BOTTOM;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

