/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.entity;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.util.resource.RowSpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.UUID;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartialEntityFlare
extends PatreonPartialEntity {
    private final PatreonEffectHelper.FlareColor flareColor;
    public Object clientSprite = null;

    public PartialEntityFlare(PatreonEffectHelper.FlareColor flareColor, UUID ownerUUID) {
        super(ownerUUID);
        this.flareColor = flareColor;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void spawnEffects() {
        super.spawnEffects();
        if (rand.nextBoolean() || !Config.enablePatreonEffects) {
            return;
        }
        int age = 30 + rand.nextInt(15);
        float scale = 0.1f + rand.nextFloat() * 0.1f;
        Vector3 at = new Vector3(this.pos);
        at.add((double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1));
        EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(at);
        particle.scale(scale).gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        particle.setColor(rand.nextInt(3) == 0 ? this.flareColor.color2 : this.flareColor.color1);
        particle.setMaxAge(age);
        if (rand.nextBoolean()) {
            particle = EffectHelper.genericFlareParticle(at);
            particle.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            particle.scale(scale * 0.3f).gravity(0.004);
            particle.setMaxAge(age - 10);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private SpriteSheetResource getSprite() {
        return RowSpriteSheetResource.crop(this.flareColor.getTexture(), this.flareColor.spriteRowIndex());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickInRenderDistance() {
        super.tickInRenderDistance();
        if (this.clientSprite != null) {
            EntityFXFacingSprite p = (EntityFXFacingSprite)this.clientSprite;
            if (p.isRemoved() && Config.enablePatreonEffects) {
                EffectHandler.getInstance().registerFX(p);
            }
        } else {
            EntityFXFacingSprite p = EntityFXFacingSprite.fromSpriteSheet(this.getSprite(), this.pos.getX(), this.pos.getY(), this.pos.getZ(), 0.35f, 2);
            p.setPositionUpdateFunction((fx, v, m) -> this.getPos());
            p.setRefreshFunc(() -> !this.removed && Config.enablePatreonEffects);
            EffectHandler.getInstance().registerFX(p);
            this.clientSprite = p;
        }
    }
}

