/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.Mods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum Plants {
    FLOWER_RED((Block)Blocks.field_150328_O, true),
    FLOWER_YELLOW((Block)Blocks.field_150327_N, true),
    GRASS((Block)Blocks.field_150329_H, true),
    MELON(Blocks.field_150440_ba),
    PUMPKIN(Blocks.field_150423_aK, true),
    SAPLING(Blocks.field_150345_g, true);

    private static final Random rand;
    private List<IBlockState> potentialBlockStates = new ArrayList<IBlockState>();

    private Plants(List<IBlockState> states) {
        this.potentialBlockStates = Lists.newArrayList(states);
    }

    private Plants(IBlockState ... states) {
        this.potentialBlockStates = Arrays.asList(states);
    }

    private Plants(IBlockState state) {
        this.potentialBlockStates = Arrays.asList(state);
    }

    private Plants(Block block, boolean unused_computeAll) {
        this(Plants.buildStates(block));
    }

    private Plants(Block block) {
        this(block.func_176223_P());
    }

    private Plants(ResourceLocation key, Mods owningMod, boolean computeAll) {
        Block b;
        if (owningMod.isPresent() && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null && b != Blocks.field_150350_a) {
            if (computeAll) {
                this.potentialBlockStates.addAll(Plants.buildStates(b));
            } else {
                this.potentialBlockStates.add(b.func_176223_P());
            }
        }
    }

    private static List<IBlockState> buildStates(Block block) {
        Object available = block.func_176194_O().func_177619_a();
        if (available.isEmpty()) {
            available = new LinkedList();
            available.add(block.func_176223_P());
        }
        return available;
    }

    public IBlockState getRandomState() {
        return this.potentialBlockStates.get(rand.nextInt(this.potentialBlockStates.size()));
    }

    private IBlockState getRandomState_Rec() {
        if (this.potentialBlockStates.isEmpty()) {
            return Plants.getAnyRandomState();
        }
        return this.potentialBlockStates.get(rand.nextInt(this.potentialBlockStates.size()));
    }

    public static IBlockState getAnyRandomState() {
        return Plants.values()[rand.nextInt(Plants.values().length)].getRandomState_Rec();
    }

    public static boolean matchesAny(IBlockState test) {
        for (Plants plant : Plants.values()) {
            if (plant.potentialBlockStates.isEmpty()) continue;
            for (IBlockState state : plant.potentialBlockStates) {
                if (!state.equals(test)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        rand = new Random();
    }
}

