/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.mappings;

import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientJournalMapping {
    private static Map<ResearchProgression, JournalCluster> map = new HashMap<ResearchProgression, JournalCluster>();

    public static void init() {
        BindableResource cloudDsc = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "cloud5");
        map.put(ResearchProgression.DISCOVERY, new JournalCluster(cloudDsc, cloudDsc, -2, -2, 0, 0));
        BindableResource cloudCraft = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "cloud2");
        map.put(ResearchProgression.BASIC_CRAFT, new JournalCluster(cloudCraft, cloudCraft, 0, 1, 3, 3));
        BindableResource cloudAtt = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "cloud4");
        map.put(ResearchProgression.ATTUNEMENT, new JournalCluster(cloudAtt, cloudAtt, 2, -2, 4, 0));
        BindableResource cloudCst = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "cloud1");
        map.put(ResearchProgression.CONSTELLATION, new JournalCluster(cloudCst, cloudCst, 4, 0, 7, 2));
        BindableResource cloudRd = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "cloud3");
        map.put(ResearchProgression.RADIANCE, new JournalCluster(cloudRd, cloudRd, 5, -3, 8, -1));
    }

    public static JournalCluster getClusterMapping(ResearchProgression progression) {
        return map.get((Object)progression);
    }

    public static class JournalCluster {
        public final BindableResource cloudTexture;
        public final BindableResource clusterBackgroundTexture;
        public final Point boundary1;
        public final Point boundary2;
        public final int leftMost;
        public final int rightMost;
        public final int upperMost;
        public final int lowerMost;

        public JournalCluster(BindableResource cloudTexture, BindableResource clusterBackgroundTexture, int leftMost, int upperMost, int rightMost, int lowerMost) {
            this.cloudTexture = cloudTexture;
            this.clusterBackgroundTexture = clusterBackgroundTexture;
            this.leftMost = leftMost;
            this.upperMost = upperMost;
            this.rightMost = rightMost;
            this.lowerMost = lowerMost;
            this.boundary1 = new Point(leftMost, upperMost);
            this.boundary2 = new Point(rightMost, lowerMost);
        }
    }
}

