/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderWorldBuffer;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class TESRTranslucentBlock
extends TileEntitySpecialRenderer<TileTranslucent> {
    private static final Map<Color, Collection<TranslucentBlockState>> blockEffects = new HashMap<Color, Collection<TranslucentBlockState>>();
    private static final Map<Color, Integer> hashes = new HashMap<Color, Integer>();
    private static final Map<Color, Integer> batches = new HashMap<Color, Integer>();

    public static void renderTranslucentBlocks() {
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GlStateManager.func_179094_E();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(Minecraft.func_71410_x().func_184121_ak());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Map.Entry<Color, Collection<TranslucentBlockState>> setBlocks : blockEffects.entrySet()) {
            Color overlay = setBlocks.getKey();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)overlay.getAlpha() / 255.0f));
            int batchList = batches.getOrDefault(setBlocks.getKey(), -1);
            Integer nullableHash = hashes.get(setBlocks.getKey());
            if (batchList == -1) {
                batches.put(overlay, TESRTranslucentBlock.batch(setBlocks.getValue(), overlay.getRGB()));
                hashes.put(overlay, TESRTranslucentBlock.hashBlocks(setBlocks.getValue()));
                setBlocks.getValue().clear();
                continue;
            }
            if (nullableHash == null) {
                GlStateManager.func_187449_e((int)batchList, (int)1);
                batches.put(overlay, TESRTranslucentBlock.batch(setBlocks.getValue(), overlay.getRGB()));
                hashes.put(overlay, TESRTranslucentBlock.hashBlocks(setBlocks.getValue()));
                setBlocks.getValue().clear();
                continue;
            }
            int newHash = TESRTranslucentBlock.hashBlocks(setBlocks.getValue());
            if (newHash == nullableHash) continue;
            GlStateManager.func_187449_e((int)batchList, (int)1);
            batches.put(overlay, TESRTranslucentBlock.batch(setBlocks.getValue(), overlay.getRGB()));
            hashes.put(overlay, newHash);
            setBlocks.getValue().clear();
        }
        GlStateManager.func_179147_l();
        Blending.CONSTANT_ALPHA.applyStateManager();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Color colorKey : blockEffects.keySet()) {
            Integer batch = batches.get(colorKey);
            if (batch != null) {
                GlStateManager.func_179148_o((int)batch);
            }
            ((Collection)blockEffects.getOrDefault(colorKey, new ArrayList(0))).clear();
        }
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static int batch(Collection<TranslucentBlockState> set, int color) {
        RenderWorldBuffer iba = new RenderWorldBuffer(Biomes.field_76772_c, Minecraft.func_71410_x().field_71441_e.func_175624_G(), new BlockArray());
        iba.appendAll(MiscUtils.splitMap(set, entry -> new Tuple<BlockPos, IBlockState>(entry.pos, entry.state)));
        int batchDList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_179147_l();
        Blending.CONSTANT_ALPHA.applyStateManager();
        GlStateManager.func_187423_f((int)batchDList, (int)4864);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (TranslucentBlockState tbs : set) {
            RenderingUtils.renderBlockSafelyWithOptionalColor(iba, tbs.pos, tbs.state, vb, color);
        }
        tes.func_78381_a();
        GlStateManager.func_187415_K();
        Blending.DEFAULT.applyStateManager();
        return batchDList;
    }

    private static int hashBlocks(Collection<TranslucentBlockState> set) {
        int hash = 80238287;
        for (TranslucentBlockState tbs : set) {
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177958_n() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177956_o() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177952_p() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.state.hashCode() * 5449 % 130651;
        }
        return hash % 75327403;
    }

    public static void cleanUp() {
        for (Integer batchList : batches.values()) {
            GlStateManager.func_187449_e((int)batchList, (int)1);
        }
        batches.clear();
        hashes.clear();
        blockEffects.clear();
    }

    public void render(TileTranslucent te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getFakedState() == null) {
            return;
        }
        IBlockState renderState = te.getFakedState();
        if (x * x + y * y + z * z >= 4096.0) {
            return;
        }
        TESRTranslucentBlock.addForRender(null, renderState, te.func_174877_v());
    }

    public static void addForRender(@Nullable Color overlay, IBlockState state, BlockPos pos) {
        blockEffects.computeIfAbsent(overlay == null ? Color.WHITE : overlay, c -> new LinkedList()).add(new TranslucentBlockState(state, pos));
    }

    public static class TranslucentBlockState {
        public final IBlockState state;
        public final BlockPos pos;

        public TranslucentBlockState(IBlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

