/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.crafting.IAltarUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryBookLookups;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class JournalPageDiscoveryRecipe
implements IJournalPage {
    public DiscoveryRecipe recipeToRender;

    public JournalPageDiscoveryRecipe(DiscoveryRecipe recipeToRender) {
        this.recipeToRender = recipeToRender;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.recipeToRender, TileAltar.AltarLevel.DISCOVERY);
    }

    public static class Render
    implements IGuiRenderablePage {
        private static final BindableResource texGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "griddisc");
        private final DiscoveryRecipe recipe;
        private final TileAltar.AltarLevel altarLevel;
        protected BindableResource gridTexture;
        private Map<Rectangle, ItemStack> thisFrameStackFrames = new HashMap<Rectangle, ItemStack>();

        public Render(DiscoveryRecipe recipe, TileAltar.AltarLevel correspondingAltarLevel) {
            this.recipe = recipe;
            this.gridTexture = texGrid;
            this.altarLevel = correspondingAltarLevel;
        }

        @Override
        public boolean propagateMouseClick(int mouseX, int mouseZ) {
            for (Rectangle r : this.thisFrameStackFrames.keySet()) {
                ItemStack stack;
                RegistryBookLookups.LookupInfo lookup;
                if (!r.contains(mouseX, mouseZ) || (lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack = this.thisFrameStackFrames.get(r))) == null) continue;
                RegistryBookLookups.openLookupJournalPage(lookup);
            }
            return false;
        }

        protected void renderStandartRecipeGrid(float offsetX, float offsetY, float zLevel, BindableResource grid) {
            GL11.glEnable((int)3042);
            Blending.DEFAULT.apply();
            grid.bind();
            this.drawRect(offsetX + 25.0f, offsetY, 129.0, 202.0, zLevel);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
        }

        protected void renderOutputOnGrid(float offsetX, float offsetY, float zLevel) {
            RenderHelper.func_74520_c();
            ItemStack out = this.recipe.getOutputForRender();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetX + 78.0f), (double)(offsetY + 25.0f), (double)(zLevel + 60.0f));
            GL11.glScaled((double)1.4, (double)1.4, (double)1.4);
            Rectangle r = this.drawItemStack(out, 0, 0, 0.0f);
            r = new Rectangle((int)offsetX + 78, (int)offsetY + 25, (int)(r.getWidth() * 1.4), (int)(r.getHeight() * 1.4));
            this.addRenderedStackRectangle(r, out);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
            RenderHelper.func_74518_a();
        }

        protected void renderDefaultExpectedItems(float offsetX, float offsetY, float zLevel, AccessibleRecipe recipe) {
            RenderHelper.func_74520_c();
            double offX = offsetX + 55.0f;
            double offY = offsetY + 103.0f;
            for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
                NonNullList<ItemStack> expected = recipe.getExpectedStackForRender(srs);
                if (expected == null || expected.isEmpty()) {
                    expected = recipe.getExpectedStackForRender(srs.rowMultipler, srs.columnMultiplier);
                }
                if (expected == null || expected.isEmpty()) continue;
                long select = (ClientScheduler.getClientTick() + (long)(srs.rowMultipler * 40) + (long)(srs.columnMultiplier * 40)) / 20L;
                ItemStack draw = (ItemStack)expected.get((int)(select %= (long)expected.size()));
                TextureHelper.refreshTextureBindState();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(offX + (double)(srs.columnMultiplier * 25)), (double)(offY + (double)(srs.rowMultipler * 25)), (double)(zLevel + 60.0f));
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
                Rectangle r = this.drawItemStack(draw, 0, 0, 0.0f);
                r = new Rectangle((int)(offX + (double)(srs.columnMultiplier * 25)), (int)(offY + (double)(srs.rowMultipler * 25)), (int)(r.getWidth() * 1.1), (int)(r.getHeight() * 1.1));
                this.addRenderedStackRectangle(r, draw);
                GL11.glPopMatrix();
            }
            RenderHelper.func_74518_a();
        }

        public void addTooltip(List<String> out) {
            if (this.recipe.getPassiveStarlightRequired() > 0) {
                TileAltar.AltarLevel highestPossible = this.altarLevel;
                ProgressionTier reached = ResearchManager.clientProgress.getTierReached();
                if (reached.isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                    highestPossible = TileAltar.AltarLevel.TRAIT_CRAFT;
                } else if (reached.isThisLaterOrEqual(ProgressionTier.CONSTELLATION_CRAFT)) {
                    highestPossible = TileAltar.AltarLevel.CONSTELLATION_CRAFT;
                } else if (reached.isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)) {
                    highestPossible = TileAltar.AltarLevel.ATTUNEMENT;
                }
                long indexSel = ClientScheduler.getClientTick() / 30L % (long)(highestPossible.ordinal() + 1);
                TileAltar.AltarLevel levelSelected = TileAltar.AltarLevel.values()[(int)indexSel];
                int max = levelSelected.getStarlightMaxStorage();
                Item i = Item.func_150898_a((Block)BlocksAS.blockAltar);
                String locTier = i.func_77667_c(new ItemStack(i, 1, levelSelected.ordinal()));
                locTier = I18n.func_135052_a((String)(locTier + ".name"), (Object[])new Object[0]);
                String displReq = "  " + this.getDescriptionFromStarlightAmount(locTier, this.recipe.getPassiveStarlightRequired(), max);
                String dsc = I18n.func_135052_a((String)"astralsorcery.journal.recipe.amt.desc", (Object[])new Object[0]);
                out.add(dsc);
                out.add(displReq);
            }
            if (this.recipe instanceof INighttimeRecipe) {
                out.add(I18n.func_135052_a((String)"astralsorcery.journal.recipe.nighttime", (Object[])new Object[0]));
            }
            if (this.recipe instanceof IAltarUpgradeRecipe) {
                out.add(I18n.func_135052_a((String)"astralsorcery.journal.recipe.upgrade", (Object[])new Object[0]));
            }
        }

        public void addStackTooltip(float mouseX, float mouseY, List<String> tooltip) {
            for (Rectangle rect : this.thisFrameStackFrames.keySet()) {
                RegistryBookLookups.LookupInfo lookup;
                if (!rect.contains(mouseX, mouseY)) continue;
                ItemStack stack = this.thisFrameStackFrames.get(rect);
                try {
                    tooltip.addAll(stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
                }
                catch (Throwable tr) {
                    tooltip.add(TextFormatting.RED + "<Error upon trying to get this item's tooltip>");
                }
                if ((lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack)) == null) continue;
                tooltip.add("");
                tooltip.add(I18n.func_135052_a((String)"misc.craftInformation", (Object[])new Object[0]));
            }
        }

        protected void addRenderedStackRectangle(Rectangle r, ItemStack rendered) {
            this.thisFrameStackFrames.put(r, rendered);
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            this.thisFrameStackFrames.clear();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderStandartRecipeGrid(offsetX, offsetY, zLevel, this.gridTexture);
            this.renderOutputOnGrid(offsetX, offsetY, zLevel);
            this.renderDefaultExpectedItems(offsetX, offsetY, zLevel, this.recipe.getNativeRecipe());
            GL11.glDisable((int)3042);
            GL11.glPopAttrib();
        }

        @Override
        public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            float widthHeightStar;
            Rectangle r;
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            LinkedList out = Lists.newLinkedList();
            this.addTooltip(out);
            if (!out.isEmpty() && (r = this.drawInfoStar(offsetX + 140.0f, offsetY + 20.0f, zLevel, widthHeightStar = 15.0f, pTicks)).contains(mouseX, mouseY)) {
                RenderingUtils.renderBlueTooltip((int)offsetX, (int)offsetY, out, this.getStandardFontRenderer());
            }
            out = Lists.newLinkedList();
            this.addStackTooltip(mouseX, mouseY, out);
            if (!out.isEmpty()) {
                RenderingUtils.renderBlueTooltip((int)mouseX, (int)mouseY, out, this.getStandardFontRenderer());
            }
            GL11.glDisable((int)3042);
            GL11.glPopAttrib();
        }
    }
}

