/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fluids.FluidStack;

public class EntityFXFluidFountain
extends EntityComplexFX {
    private static final Random rand = new Random();
    private TextureAtlasSprite tas;
    private Vector3 offset;
    private FluidStack fluidStack;

    private EntityFXFluidFountain(Vector3 offset, int maxAge, TextureAtlasSprite tas, FluidStack fluid) {
        this.offset = offset;
        this.maxAge = maxAge;
        this.tas = tas;
        this.fluidStack = fluid;
    }

    public static EntityFXFluidFountain spawnAt(Vector3 pos, FluidStack fluid) {
        TextureAtlasSprite tas = RenderingUtils.tryGetFlowingTextureOfFluidStack(fluid);
        EntityFXFluidFountain f = new EntityFXFluidFountain(pos, 60, tas, fluid);
        EffectHandler.getInstance().registerFX(f);
        return f;
    }

    @Override
    public void tick() {
        super.tick();
        EntityFXFloatingCube cube = new EntityFXFloatingCube(this.tas);
        cube.setPosition(this.offset);
        cube.setTextureSubSizePercentage(0.0625f).setMaxAge(40 + rand.nextInt(40));
        cube.setScale(0.3f).tumble();
        Vector3 v = Vector3.positiveYRandom();
        v.setY(v.getY() * 8.0).normalize().multiply(new Vector3(0.01f + rand.nextFloat() * 0.015f, 0.09f + rand.nextFloat() * 0.015f, 0.01f + rand.nextFloat() * 0.015f));
        cube.setMotion(v);
        cube.setMotionController((c, motion) -> motion.setY(motion.getY() - (double)0.003f));
        cube.setColorHandler(cb -> new Color(this.fluidStack.getFluid().getColor(this.fluidStack)));
        EffectHandler.getInstance().registerFX(cube);
    }

    @Override
    public void render(float pTicks) {
    }
}

