/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import cofh.core.block.TileRSControl;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.storage.TileCell;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.reference.Colors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@TOPAddon(dependency="thermalexpansion")
public class AddonThermalExpansion
extends AddonBlank {
    private static final int[][] PROGRESS_COLOURS = new int[][]{{-5592406, -6316129}, {-7431531, -8616063}, {-2699215, -3951340}, {-2531296, -4242413}, {-13533056, -14394276}};

    @Override
    public void addFluidColors() {
        Colors.FLUID_NAME_COLOR_MAP.put("crude_oil", -14474461);
        Colors.FLUID_NAME_COLOR_MAP.put("redstone", -7730679);
        Colors.FLUID_NAME_COLOR_MAP.put("glowstone", -3756281);
        Colors.FLUID_NAME_COLOR_MAP.put("ender", -15638434);
        Colors.FLUID_NAME_COLOR_MAP.put("pyrotheum", -2245858);
        Colors.FLUID_NAME_COLOR_MAP.put("cryotheum", -15810870);
        Colors.FLUID_NAME_COLOR_MAP.put("aerotheum", -8882604);
        Colors.FLUID_NAME_COLOR_MAP.put("petrotheum", -15133936);
        Colors.FLUID_NAME_COLOR_MAP.put("mana", -16166281);
        Colors.FLUID_NAME_COLOR_MAP.put("steam", -8157822);
        Colors.FLUID_NAME_COLOR_MAP.put("creosote", -11447038);
        Colors.FLUID_NAME_COLOR_MAP.put("coal", -13027015);
        Colors.FLUID_NAME_COLOR_MAP.put("refined_oil", -3970529);
        Colors.FLUID_NAME_COLOR_MAP.put("refined_fuel", -3955435);
        Colors.FLUID_NAME_COLOR_MAP.put("sap", -8498667);
        Colors.FLUID_NAME_COLOR_MAP.put("syrup", -7980797);
        Colors.FLUID_NAME_COLOR_MAP.put("resin", -4883452);
        Colors.FLUID_NAME_COLOR_MAP.put("tree_oil", -4942267);
        Colors.FLUID_NAME_COLOR_MAP.put("mushroom_stew", -3626609);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileMachineBase) {
            TileMachineBase machine = (TileMachineBase)tile;
            if (machine.isActive) {
                IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(5));
                this.progressBar(hori, machine.getScaledProgress(100), PROGRESS_COLOURS[machine.getLevel()][0], PROGRESS_COLOURS[machine.getLevel()][1]);
                hori.text(TextStyleClass.LABEL + "@ " + TextStyleClass.INFO + machine.getInfoEnergyPerTick() + " RF/t");
            }
        }
        if (tile instanceof TileDynamoBase) {
            TileDynamoBase dynamo = (TileDynamoBase)tile;
            if (dynamo.isActive) {
                AddonThermalExpansion.textPrefixed(probeInfo, "Power output", String.format("%d RF/t", dynamo.getInfoEnergyPerTick()));
            }
        }
        if (tile instanceof TileCell) {
            TileCell cell = (TileCell)tile;
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).icon(new ResourceLocation("cofh:textures/gui/elements/info_input.png"), 0, 0, 10, 10, probeInfo.defaultIconStyle().textureHeight(10).textureWidth(10).width(15).height(10)).text(TextStyleClass.LABEL + String.format("%d RF/t", cell.amountRecv));
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).icon(new ResourceLocation("cofh:textures/gui/elements/info_output.png"), 0, 0, 10, 10, probeInfo.defaultIconStyle().textureHeight(10).textureWidth(10).width(15).height(10)).text(TextStyleClass.LABEL + String.format("%d RF/t", cell.amountSend));
        }
        if (tile instanceof TileRSControl && !((TileRSControl)tile).redstoneControlOrDisable()) {
            probeInfo.text(TextFormatting.RED + "Disabled");
        }
    }
}

