/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.net;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesTeamData;
import com.feed_the_beast.ftbutilities.events.chunks.UpdateClientDataEvent;
import com.feed_the_beast.ftbutilities.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;

public class MessageClaimedChunksUpdate
extends MessageToClient {
    public int startX;
    public int startZ;
    public int claimedChunks;
    public int loadedChunks;
    public int maxClaimedChunks;
    public int maxLoadedChunks;
    public Short2ObjectOpenHashMap<ClientClaimedChunks.Team> teams;

    public MessageClaimedChunksUpdate() {
    }

    public MessageClaimedChunksUpdate(int sx, int sz, EntityPlayer player) {
        this.startX = sx;
        this.startZ = sz;
        ForgePlayer p = Universe.get().getPlayer((ICommandSender)player);
        FTBUtilitiesTeamData teamData = FTBUtilitiesTeamData.get(p.team);
        List<ClaimedChunk> chunks = teamData.team.isValid() ? ClaimedChunks.instance.getTeamChunks(teamData.team, OptionalInt.empty()) : Collections.emptyList();
        this.claimedChunks = chunks.size();
        this.loadedChunks = 0;
        for (ClaimedChunk c : chunks) {
            if (!c.isLoaded()) continue;
            ++this.loadedChunks;
        }
        this.maxClaimedChunks = teamData.getMaxClaimChunks();
        this.maxLoadedChunks = teamData.getMaxChunkloaderChunks();
        this.teams = new Short2ObjectOpenHashMap();
        boolean canSeeChunkInfo = PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbutilities.other_player.claims.see_info");
        for (int x1 = 0; x1 < 15; ++x1) {
            for (int z1 = 0; z1 < 15; ++z1) {
                ForgeTeam chunkTeam;
                ChunkDimPos pos = new ChunkDimPos(this.startX + x1, this.startZ + z1, player.field_71093_bK);
                ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos);
                if (chunk == null || !(chunkTeam = chunk.getTeam()).isValid()) continue;
                ClientClaimedChunks.Team team = (ClientClaimedChunks.Team)this.teams.get(chunkTeam.getUID());
                if (team == null) {
                    team = new ClientClaimedChunks.Team(chunkTeam.getUID());
                    team.color = chunkTeam.getColor();
                    team.nameComponent = chunkTeam.getTitle();
                    team.isAlly = chunkTeam.isAlly(p);
                    this.teams.put(chunkTeam.getUID(), (Object)team);
                }
                boolean member = chunkTeam.isMember(p);
                int flags = 0;
                if ((canSeeChunkInfo || member) && chunk.isLoaded()) {
                    flags = Bits.setFlag((int)flags, (int)1, (boolean)true);
                }
                team.chunks.put(x1 + z1 * 15, new ClientClaimedChunks.ChunkData(team, flags));
            }
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUtilitiesNetHandler.CLAIMS;
    }

    public void writeData(DataOut data) {
        data.writeVarInt(this.startX);
        data.writeVarInt(this.startZ);
        data.writeVarInt(this.claimedChunks);
        data.writeVarInt(this.loadedChunks);
        data.writeVarInt(this.maxClaimedChunks);
        data.writeVarInt(this.maxLoadedChunks);
        data.writeCollection((Collection)this.teams.values(), ClientClaimedChunks.Team.SERIALIZER);
    }

    public void readData(DataIn data) {
        this.startX = data.readVarInt();
        this.startZ = data.readVarInt();
        this.claimedChunks = data.readVarInt();
        this.loadedChunks = data.readVarInt();
        this.maxClaimedChunks = data.readVarInt();
        this.maxLoadedChunks = data.readVarInt();
        this.teams = new Short2ObjectOpenHashMap();
        for (ClientClaimedChunks.Team team : data.readCollection(ClientClaimedChunks.Team.DESERIALIZER)) {
            this.teams.put(team.uid, (Object)team);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new UpdateClientDataEvent(this).post();
    }
}

