/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui.ranks;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbutilities.gui.ranks.GuiRanks;
import com.feed_the_beast.ftbutilities.gui.ranks.GuiSelectRank;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;

public class GuiPlayerRanks
extends GuiButtonListBase {
    private final GuiRanks guiRanks;
    private int usernameSize;
    private int valueSize;

    public GuiPlayerRanks(GuiRanks g) {
        this.guiRanks = g;
        this.setTitle(I18n.func_135052_a((String)"admin_panel.ftbutilities.ranks.player_ranks", (Object[])new Object[0]));
        this.setHasSearchBox(true);
    }

    public void addButtons(Panel panel) {
        this.usernameSize = 0;
        this.valueSize = 0;
        for (Map.Entry<String, String> entry : this.guiRanks.playerRanks.entrySet()) {
            panel.add((Widget)new PlayerEntry(panel, entry.getKey(), entry.getValue()));
        }
        panel.widgets.sort(null);
    }

    public String getFilterText(Widget widget) {
        return ((PlayerEntry)widget).username.toLowerCase();
    }

    private class PlayerEntry
    extends Button
    implements Comparable<PlayerEntry> {
        private final String username;
        private String rank;

        public PlayerEntry(Panel panel, String u, String r) {
            super(panel);
            this.username = u;
            this.rank = StringUtils.firstUppercase((String)(r.isEmpty() ? "none" : r));
            Theme theme = GuiPlayerRanks.this.getTheme();
            GuiPlayerRanks.this.usernameSize = Math.max(GuiPlayerRanks.this.usernameSize, theme.getStringWidth(this.username) + 8);
            GuiPlayerRanks.this.valueSize = Math.max(GuiPlayerRanks.this.valueSize, theme.getStringWidth(this.rank) + 8);
            this.setSize(GuiPlayerRanks.this.usernameSize + GuiPlayerRanks.this.valueSize, 14);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiSelectRank(GuiPlayerRanks.this.guiRanks, rank -> true, rank -> {
                String s;
                String string = s = rank == null ? "" : rank.getID();
                if (!s.equals(((GuiPlayerRanks)GuiPlayerRanks.this).guiRanks.playerRanks.put(this.username, s))) {
                    ClientUtils.execClientCommand((String)("/ranks set " + this.username + " " + (rank == null ? "none" : rank.getID())));
                    this.getGui().refreshWidgets();
                }
            }).openGui();
        }

        public void addMouseOverText(List<String> list) {
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            WidgetType type = WidgetType.mouseOver((boolean)this.isMouseOver());
            int textY = y + (h - theme.getFontHeight() + 1) / 2;
            theme.drawButton(x, y, GuiPlayerRanks.this.usernameSize, h, type);
            theme.drawString(this.username, x + 4, textY, 2);
            theme.drawButton(x + GuiPlayerRanks.this.usernameSize, y, GuiPlayerRanks.this.valueSize, h, type);
            theme.drawString(this.rank, x + GuiPlayerRanks.this.usernameSize + 4, textY, 2);
        }

        @Override
        public int compareTo(PlayerEntry o) {
            return this.username.compareToIgnoreCase(o.username);
        }
    }
}

