/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.client.CachedVertexData;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbutilities.net.MessageSendWarpList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;

public class GuiWarps
extends GuiBase {
    public static GuiWarps INSTANCE = null;
    private static final int SIZE = 220;
    private static final int SIZE_2 = 110;
    private static final int SIZE_I = 27;
    private static final int SIZE_C = 66;
    private static final CachedVertexData BACKGROUND = new CachedVertexData(6, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CIRCLE_IN = new CachedVertexData(3, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CIRCLE_OUT = new CachedVertexData(3, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CENTER = new CachedVertexData(6, DefaultVertexFormats.field_181706_f);
    private final ArcButton buttonCancel;
    private boolean isLoaded = false;
    private List<ArcButton> buttonsIn;
    private List<ArcButton> buttonsOut;
    private ArcButton buttonOver = null;
    private CachedVertexData lines;

    public GuiWarps() {
        this.setSize(220, 220);
        this.buttonCancel = new ArcButton(this, MessageSendWarpList.WarpItem.CANCEL, -1);
    }

    public void addWidgets() {
        if (this.isLoaded) {
            this.addAll(this.buttonsIn);
            this.addAll(this.buttonsOut);
            this.add((Widget)this.buttonCancel);
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        x += 110;
        y += 110;
        if (!this.isLoaded) {
            return;
        }
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_178969_c((double)x, (double)y, 0.0);
        BACKGROUND.draw(tessellator, buffer);
        CIRCLE_IN.draw(tessellator, buffer);
        CIRCLE_OUT.draw(tessellator, buffer);
        CENTER.draw(tessellator, buffer);
        if (this.isLoaded) {
            this.lines.draw(tessellator, buffer);
        }
        this.buttonOver = this.buttonCancel;
        double dist = MathUtils.dist((double)x, (double)y, (double)this.getMouseX(), (double)this.getMouseY());
        double rotation = Math.toDegrees(Math.atan2(this.getMouseY() - y, this.getMouseX() - x));
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        if (this.isLoaded) {
            if (dist >= 27.0 && dist <= 110.0) {
                this.buttonOver = dist < 66.0 ? this.buttonsIn.get((int)(rotation / (360.0 / (double)this.buttonsIn.size())) % this.buttonsIn.size()) : this.buttonsOut.get((int)(rotation / (360.0 / (double)this.buttonsOut.size())) % this.buttonsOut.size());
            }
            if (this.buttonOver.warpItem.isSpecial()) {
                theme.drawString(TextFormatting.BOLD + ((ArcButton)this.buttonOver).warpItem.name, x, y - 4, 5);
            } else {
                theme.drawString(TextFormatting.BOLD + (this.buttonOver.warpItem.innerCircle() ? "Home" : "Warp"), x, y - 9, 5);
                theme.drawString(((ArcButton)this.buttonOver).warpItem.name, x, y + 1, 5);
            }
        }
    }

    public void setData(List<MessageSendWarpList.WarpItem> list) {
        double sin;
        this.buttonsIn = new ArrayList<ArcButton>();
        this.buttonsOut = new ArrayList<ArcButton>();
        for (MessageSendWarpList.WarpItem w : list) {
            List<ArcButton> l = w.innerCircle() ? this.buttonsIn : this.buttonsOut;
            l.add(new ArcButton(this, w, l.size()));
        }
        this.lines = new CachedVertexData(1, DefaultVertexFormats.field_181706_f);
        if (this.buttonsOut.size() > 1) {
            int add = 360 / this.buttonsOut.size();
            for (int i = 0; i < 360; i += add) {
                double cos = Math.cos(Math.toRadians(i));
                sin = Math.sin(Math.toRadians(i));
                this.lines.pos(cos * 66.0, sin * 66.0, 0.0).color(102, 102, 102, 255);
                this.lines.pos(cos * 110.0, sin * 110.0, 0.0).color(102, 102, 102, 255);
            }
        }
        if (this.buttonsIn.size() > 1) {
            int add = 360 / this.buttonsIn.size();
            for (int i = 0; i < 360; i += add) {
                double cos = Math.cos(Math.toRadians(i));
                sin = Math.sin(Math.toRadians(i));
                this.lines.pos(cos * 27.0, sin * 27.0, 0.0).color(102, 102, 102, 255);
                this.lines.pos(cos * 66.0, sin * 66.0, 0.0).color(102, 102, 102, 255);
            }
        }
        this.isLoaded = true;
        this.refreshWidgets();
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    static {
        BACKGROUND.pos(0.0, 0.0).color(170, 170, 170, 153);
        CENTER.pos(0.0, 0.0).color(102, 102, 102, 255);
        for (int i = 0; i <= 360; i += 6) {
            double cos = Math.cos(Math.toRadians(i));
            double sin = Math.sin(Math.toRadians(i));
            BACKGROUND.pos(cos * 110.0, sin * 110.0).color(200, 200, 200, 153);
            CIRCLE_OUT.pos(cos * 110.0, sin * 110.0).color(102, 102, 102, 255);
            CIRCLE_IN.pos(cos * 66.0, sin * 66.0).color(102, 102, 102, 255);
            CENTER.pos(cos * 27.0, sin * 27.0).color(102, 102, 102, 255);
        }
    }

    private class ArcButton
    extends Button {
        private final MessageSendWarpList.WarpItem warpItem;
        private final int index;
        private int textX;
        private int textY;

        public ArcButton(GuiBase gui, MessageSendWarpList.WarpItem w, int i) {
            super((Panel)gui);
            this.textX = -1;
            this.textY = -1;
            this.setSize(0, 0);
            this.setTitle(w.cmd);
            this.warpItem = w;
            this.index = i;
        }

        public boolean collidesWith(int x, int y, int w, int h) {
            return true;
        }

        public boolean checkMouseOver(int mouseX, int mouseY) {
            return this == GuiWarps.this.buttonOver;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            if (this.index == -1) {
                return;
            }
            if (this.textX == -1) {
                boolean in = this.warpItem.innerCircle();
                double s = (in ? GuiWarps.this.buttonsIn : GuiWarps.this.buttonsOut).size();
                double i = s > 1.0 ? (double)this.index * (360.0 / s) + 180.0 / s : 270.0;
                double d = (double)(in ? 93 : 176) / 2.0;
                this.textX = (int)(Math.cos(Math.toRadians(i)) * d);
                this.textY = (int)(Math.sin(Math.toRadians(i)) * d) - 2;
            }
            theme.drawString(this.warpItem.name, this.getGui().posX + this.getGui().width / 2 + this.textX, this.getGui().posY + this.getGui().height / 2 + this.textY, 5);
        }

        public void onClicked(MouseButton button) {
            if (!this.warpItem.cmd.isEmpty()) {
                ClientUtils.execClientCommand((String)this.warpItem.cmd, (boolean)true);
            }
            this.getGui().closeGui();
        }
    }
}

