/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClientConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public class CmdScanItems
extends CmdBase {
    public CmdScanItems() {
        super("scan_items", CmdBase.Level.ALL);
    }

    public static boolean filter(ItemEntry entry) {
        String s = entry.item.getRegistryName().toString();
        for (String s1 : FTBUtilitiesClientConfig.general.scan_items_whitelist) {
            if (!s.startsWith(s1)) continue;
            return true;
        }
        for (String s1 : FTBUtilitiesClientConfig.general.scan_items_blacklist) {
            if (!s.startsWith(s1)) continue;
            return false;
        }
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        sender.func_145747_a((ITextComponent)new TextComponentString("Exporting debug files..."));
        new Thread(() -> {
            ArrayList<String> list = new ArrayList<String>();
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                FluidStack stack = new FluidStack(fluid, 1000);
                ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(fluid.getStill(stack).func_110624_b());
                list.add(fluid.getName() + " ;; " + stack.getLocalizedName() + " ;; " + (mod == null ? "Unknown" : mod.getName()));
            }
            CmdScanItems.saveFile(list, "fluids.txt");
        }).start();
        new Thread(() -> {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            NonNullList stacks = NonNullList.func_191196_a();
            LinkedHashMap<String, LinkedHashSet<ItemEntry>> itemToDisplayNameMap = new LinkedHashMap<String, LinkedHashSet<ItemEntry>>();
            for (Item item : Item.field_150901_e) {
                stacks.clear();
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                for (ItemStack stack : stacks) {
                    ItemEntry itemEntry = ItemEntry.get((ItemStack)stack);
                    if (stack.func_190926_b() || !CmdScanItems.filter(itemEntry)) continue;
                    String displayName = stack.func_82833_r();
                    LinkedHashSet<ItemEntry> set = (LinkedHashSet<ItemEntry>)itemToDisplayNameMap.get(displayName);
                    if (set == null) {
                        set = new LinkedHashSet<ItemEntry>();
                        itemToDisplayNameMap.put(displayName, set);
                    }
                    set.add(itemEntry);
                }
            }
            for (Map.Entry entry : itemToDisplayNameMap.entrySet()) {
                if (((LinkedHashSet)entry.getValue()).size() <= 1) continue;
                list.add((String)entry.getKey());
                for (ItemEntry itemEntry : (LinkedHashSet)entry.getValue()) {
                    builder.append('-');
                    builder.append(' ');
                    itemEntry.toString(builder);
                    list.add(builder.toString());
                    builder.setLength(0);
                }
                list.add("");
            }
            CmdScanItems.saveFile(list, "dupe_display_names.txt");
        }).start();
        new Thread(() -> {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (String ore : OreDictionary.getOreNames()) {
                NonNullList oreItems = OreDictionary.getOres((String)ore);
                if (oreItems.size() <= 1) continue;
                boolean added = false;
                for (ItemStack stack : oreItems) {
                    ItemEntry itemEntry = ItemEntry.get((ItemStack)stack);
                    if (itemEntry.isEmpty() || !CmdScanItems.filter(itemEntry)) continue;
                    if (!added) {
                        added = true;
                        list.add(ore);
                    }
                    builder.append('-');
                    builder.append(' ');
                    itemEntry.toString(builder);
                    list.add(builder.toString());
                    builder.setLength(0);
                }
                list.add("");
            }
            CmdScanItems.saveFile(list, "ore_name_dupes.txt");
        }).start();
    }

    private static void saveFile(List<String> list, String file) {
        File f = new File(ClientUtils.MC.field_71412_D, "local/client/ftbjanitor/" + file);
        FileUtils.saveSafe((File)f, list);
        TextComponentString component = new TextComponentString(file + " saved! Click here to open.");
        try {
            component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getCanonicalFile().getAbsolutePath()));
        }
        catch (Exception ex) {
            component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath()));
        }
        ClientUtils.MC.field_71439_g.func_145747_a((ITextComponent)component);
    }
}

