/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidatedNBT;
import cofh.core.inventory.OreValidator;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;

public class EnchanterManager {
    private static Map<List<ComparableItemStackValidatedNBT>, EnchanterRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidatedNBT> validationSet = new ObjectOpenHashSet();
    private static Set<ComparableItemStackValidatedNBT> lockSet = new ObjectOpenHashSet();
    private static OreValidator oreValidator = new OreValidator();
    public static final ItemStack ITEM_BOOK;
    public static final int[] DEFAULT_ENERGY;
    public static final int[] DEFAULT_EXPERIENCE;

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return false;
        }
        ComparableItemStackValidatedNBT query = EnchanterManager.convertInput(primaryInput);
        ComparableItemStackValidatedNBT querySecondary = EnchanterManager.convertInput(secondaryInput);
        EnchanterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        return recipe == null && recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static EnchanterRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        ComparableItemStackValidatedNBT querySecondary;
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidatedNBT query = EnchanterManager.convertInput(primaryInput);
        EnchanterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary = EnchanterManager.convertInput(secondaryInput)));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return EnchanterManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static EnchanterRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new EnchanterRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(EnchanterManager.convertInput(input));
    }

    public static boolean isItemArcana(ItemStack input) {
        return !input.func_190926_b() && lockSet.contains(EnchanterManager.convertInput(input));
    }

    public static void preInit() {
        EnchanterManager.addArcana(new ItemStack(Items.field_151122_aG));
    }

    public static void initialize() {
        EnchanterManager.addEnchantmentBooks();
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        for (Map.Entry<List<ComparableItemStackValidatedNBT>, EnchanterRecipe> entry : recipeMap.entrySet()) {
            Enchantment enchant;
            EnchanterRecipe tempRecipe = entry.getValue();
            ComparableItemStackValidatedNBT primary = EnchanterManager.convertInput(tempRecipe.primaryInput);
            ComparableItemStackValidatedNBT secondary = EnchanterManager.convertInput(tempRecipe.secondaryInput);
            if (!tempRecipe.enchantName.isEmpty() && tempRecipe.output.func_77973_b() == Items.field_151134_bR && (enchant = Enchantment.func_180305_b((String)tempRecipe.enchantName)) != null) {
                tempRecipe = new EnchanterRecipe(tempRecipe.primaryInput, tempRecipe.secondaryInput, ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchant, 1)), tempRecipe.experience, tempRecipe.energy, tempRecipe.type);
            }
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        ObjectOpenHashSet tempSet2 = new ObjectOpenHashSet();
        for (ComparableItemStackValidatedNBT entry : lockSet) {
            ComparableItemStackValidatedNBT lock = EnchanterManager.convertInput(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static EnchanterRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack output, int experience, Type type) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || energy <= 0 || EnchanterManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        EnchanterRecipe recipe = new EnchanterRecipe(primaryInput, secondaryInput, output, experience, energy, type);
        recipeMap.put(Arrays.asList(EnchanterManager.convertInput(primaryInput), EnchanterManager.convertInput(secondaryInput)), recipe);
        validationSet.add(EnchanterManager.convertInput(primaryInput));
        validationSet.add(EnchanterManager.convertInput(secondaryInput));
        return recipe;
    }

    public static void addDefaultEnchantmentRecipe(ItemStack input, String enchantName, int tier) {
        if (tier < 0 || tier > 4) {
            return;
        }
        Enchantment enchant = Enchantment.func_180305_b((String)enchantName);
        if (enchant == null) {
            return;
        }
        EnchanterManager.addRecipe(DEFAULT_ENERGY[tier], ITEM_BOOK, input, ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchant, 1)), DEFAULT_EXPERIENCE[tier], Type.STANDARD);
    }

    public static EnchanterRecipe removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        return recipeMap.remove(Arrays.asList(EnchanterManager.convertInput(primaryInput), EnchanterManager.convertInput(secondaryInput)));
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack, oreValidator);
    }

    private static void addArcana(ItemStack arcana) {
        lockSet.add(EnchanterManager.convertInput(arcana));
    }

    private static void addEnchantmentBooks() {
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150343_Z), "unbreaking", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151156_bN), "mending", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_185162_cT), "binding_curse", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151042_j), "protection", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151064_bs), "fire_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151008_G), "feather_falling", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151016_H), "blast_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_185159_cQ), "projectile_protection", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151115_aP, 1, 3), "respiration", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_179563_cD), "aqua_affinity", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_179562_cC), "depth_strider", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), "thorns", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150432_aD), "frost_walker", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151073_bk), "vanishing_curse", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151128_bU), "sharpness", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151078_bh), "smite", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151070_bp), "bane_of_arthropods", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150331_J), "knockback", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151072_bj), "fire_aspect", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151043_k), "looting", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151120_aE), "sweeping", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151137_ax), "efficiency", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151166_bC), "fortune", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151114_aO), "silk_touch", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151145_ak), "power", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151007_F), "punch", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151065_br), "flame", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151061_bv), "infinity", 3);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151115_aP, 1, 2), "luck_of_the_sea", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151146_bM), "lure", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack((Block)Blocks.field_150486_ae), "cofhcore:holding", 0);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151062_by), "cofhcore:insight", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151075_bm), "cofhcore:leech", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151032_g), "cofhcore:multishot", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(ItemMaterial.dustPetrotheum, "cofhcore:smashing", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(ItemMaterial.dustPyrotheum, "cofhcore:smelting", 2);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Blocks.field_150425_aM), "cofhcore:soulbound", 1);
        EnchanterManager.addDefaultEnchantmentRecipe(new ItemStack(Items.field_151144_bL, 1, 1), "cofhcore:vorpal", 3);
    }

    static {
        oreValidator.addPrefix("ingot");
        oreValidator.addPrefix("nugget");
        oreValidator.addPrefix("dust");
        oreValidator.addPrefix("gem");
        ITEM_BOOK = new ItemStack(Items.field_151122_aG);
        DEFAULT_ENERGY = new int[]{4000, 12000, 24000, 40000, 60000};
        DEFAULT_EXPERIENCE = new int[]{500, 1500, 3000, 5000, 7500};
    }

    public static enum Type {
        STANDARD,
        EMPOWERED;

    }

    public static class EnchanterRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack output;
        final int experience;
        final int energy;
        final String enchantName;
        final Type type;

        EnchanterRecipe(ItemStack primaryInput, ItemStack secondaryInput, ItemStack output, int experience, int energy, Type type) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.output = output;
            this.experience = experience;
            this.energy = energy;
            this.type = type;
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)output);
            this.enchantName = enchants.isEmpty() || enchants.size() > 1 ? "" : ((Enchantment)enchants.keySet().stream().findFirst().get()).getRegistryName().toString();
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getExperience() {
            return this.experience;
        }

        public String getEnchantName() {
            return this.enchantName;
        }

        public Type getType() {
            return this.type;
        }
    }
}

