/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.util.NBTUtils;
import net.darkhax.bookshelf.util.OreDictUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class StackUtils {
    private StackUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static NBTTagCompound prepareStackTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static ItemStack prepareStack(ItemStack stack) {
        StackUtils.prepareStackTag(stack);
        return stack;
    }

    public static ItemStack setLore(ItemStack stack, String ... lore) {
        NBTTagList loreList = new NBTTagList();
        for (String line : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        return StackUtils.setLoreTag(stack, loreList);
    }

    public static List<String> getLore(ItemStack stack) {
        ArrayList<String> result = new ArrayList<String>();
        NBTTagList lore = StackUtils.getLoreTag(stack);
        if (!lore.func_82582_d()) {
            for (int l1 = 0; l1 < lore.func_74745_c(); ++l1) {
                result.add(lore.func_150307_f(l1));
            }
        }
        return result;
    }

    public static ItemStack appendLore(ItemStack stack, String ... lore) {
        NBTTagList loreTag = StackUtils.getLoreTag(stack);
        for (String line : lore) {
            loreTag.func_74742_a((NBTBase)new NBTTagString(line));
        }
        return stack;
    }

    public static ItemStack setLoreTag(ItemStack stack, NBTTagList lore) {
        NBTTagCompound displayTag = StackUtils.getDisplayTag(stack);
        displayTag.func_74782_a("Lore", (NBTBase)lore);
        return stack;
    }

    public static NBTTagCompound getDisplayTag(ItemStack stack) {
        StackUtils.prepareStackTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("display");
    }

    public static NBTTagList getLoreTag(ItemStack stack) {
        NBTTagCompound displayTag = StackUtils.getDisplayTag(stack);
        if (!displayTag.func_74764_b("Lore")) {
            displayTag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        return displayTag.func_150295_c("Lore", 8);
    }

    public static String writeStackToString(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString() + "#" + stack.func_77952_i();
    }

    public static ItemStack createStackFromString(String stackString) {
        String[] parts = stackString.split("#");
        Object contents = StackUtils.getThingByName(parts[0]);
        int damage = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        return contents instanceof Item ? new ItemStack((Item)contents, 1, damage) : new ItemStack((Block)contents, 1, damage);
    }

    public static boolean compareStackToOreName(ItemStack stack, String oreName) {
        for (int stackName : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)stackName).equalsIgnoreCase(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean doStacksShareOreName(ItemStack firstStack, ItemStack secondStack) {
        for (int firstName : OreDictionary.getOreIDs((ItemStack)firstStack)) {
            for (int secondName : OreDictionary.getOreIDs((ItemStack)secondStack)) {
                if (firstName != secondName) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksSimilar(@Nonnull ItemStack firstStack, @Nonnull ItemStack secondStack) {
        return firstStack.func_77973_b() == secondStack.func_77973_b() && StackUtils.areStacksSameMeta(firstStack, secondStack);
    }

    public static boolean areStacksSimilarWithSize(ItemStack firstStack, ItemStack secondStack) {
        return StackUtils.areStacksSimilar(firstStack, secondStack) && firstStack.func_190916_E() == secondStack.func_190916_E();
    }

    public static boolean areStacksSimilarWithPartialNBT(ItemStack firstStack, ItemStack secondStack) {
        return StackUtils.areStacksSimilar(firstStack, secondStack) && NBTUtils.containsAllTags(StackUtils.getTagCleanly(firstStack), StackUtils.getTagCleanly(secondStack));
    }

    public static boolean areStacksSameMeta(@Nonnull ItemStack first, @Nonnull ItemStack second) {
        return first.func_77960_j() == second.func_77960_j() || first.func_77960_j() == Short.MAX_VALUE || second.func_77960_j() == Short.MAX_VALUE;
    }

    public static boolean areStacksEqualForCrafting(ItemStack stack, Object recipe) {
        if (recipe instanceof ItemStack) {
            return StackUtils.areStacksSimilarWithSize(stack, (ItemStack)recipe);
        }
        if (recipe instanceof String) {
            return StackUtils.hasOreName(stack, (String)recipe);
        }
        return false;
    }

    public static boolean hasOreName(ItemStack stack, String name) {
        return OreDictUtils.getOreNames(stack).contains(name);
    }

    public static ItemStack writePotionEffectsToStack(ItemStack stack, PotionEffect[] effects) {
        NBTTagCompound stackTag = StackUtils.prepareStackTag(stack);
        NBTTagList potionTag = new NBTTagList();
        for (PotionEffect effect : effects) {
            potionTag.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
        }
        stackTag.func_74782_a("CustomPotionEffects", (NBTBase)potionTag);
        return stack;
    }

    public static void writeStackToTag(ItemStack stack, NBTTagCompound tag, String tagName) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stack.func_77955_b(stackTag);
        tag.func_74782_a(tagName, (NBTBase)stackTag);
    }

    public static ItemStack decreaseStackSize(ItemStack stack, int amount) {
        stack.func_190918_g(amount);
        return stack.func_190916_E() <= 0 ? ItemStack.field_190927_a : stack;
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, boolean checkNBT) {
        if (firstStack == null || secondStack == null) {
            return firstStack == secondStack;
        }
        Item firstItem = firstStack.func_77973_b();
        Item secondItem = secondStack.func_77973_b();
        if (firstItem == null || secondItem == null) {
            return firstItem == secondItem;
        }
        if (firstItem == secondItem) {
            if (checkNBT && NBTUtils.NBT_COMPARATOR.compare(firstStack.func_77978_p(), secondStack.func_77978_p()) != 0) {
                return false;
            }
            return firstStack.func_77952_i() == Short.MAX_VALUE || secondStack.func_77952_i() == Short.MAX_VALUE || firstStack.func_77952_i() == secondStack.func_77952_i();
        }
        return false;
    }

    public static boolean isStackInArray(ItemStack stack, boolean checkNBT, ItemStack ... stacks) {
        for (ItemStack currentStack : stacks) {
            if (!StackUtils.areStacksEqual(stack, currentStack, checkNBT)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int size) {
        ItemStack output = stack.func_77946_l();
        output.func_190920_e(size);
        return output;
    }

    public static Object getThingByName(String name) {
        Item thing = Item.func_111206_d((String)name);
        if (thing != null) {
            return thing;
        }
        thing = Block.func_149684_b((String)name);
        if (thing != null) {
            return thing;
        }
        return null;
    }

    public static Block getBlockFromStack(ItemStack stack) {
        return !stack.func_190926_b() ? Block.func_149634_a((Item)stack.func_77973_b()) : Blocks.field_150350_a;
    }

    public static ItemStack consumeStack(ItemStack stack) {
        if (stack.func_190916_E() == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return ItemStack.field_190927_a;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static void dropStackInWorld(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float offset = 0.7f;
            double offX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + offX, (double)pos.func_177956_o() + offY, (double)pos.func_177952_p() + offZ, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack createStackFromTileEntity(TileEntity tile) {
        ItemStack stack = new ItemStack(tile.func_145838_q(), 1, tile.func_145832_p());
        StackUtils.prepareStackTag(stack);
        NBTTagCompound tileTag = tile.func_189515_b(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("TileData", (NBTBase)tileTag);
        return stack;
    }

    public static void readTileEntityFromStack(TileEntity tile, ItemStack stack) {
        tile.func_145839_a(stack.func_77978_p().func_74775_l("TileData"));
    }

    @Deprecated
    public static ItemStack getStackFromState(IBlockState state, int size) {
        return new ItemStack(state.func_177230_c(), size, state.func_177230_c().func_180651_a(state));
    }

    @Deprecated
    public static IBlockState getStateFromStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block != null ? block.func_176203_a(stack.func_77960_j()) : null;
    }

    public static NonNullList<ItemStack> findVariations(Item item) {
        NonNullList items = NonNullList.func_191196_a();
        for (CreativeTabs tab : item.getCreativeTabs()) {
            if (tab == null) {
                if (item == Items.field_151134_bR) {
                    item.func_150895_a(CreativeTabs.field_78027_g, items);
                }
                items.add((Object)new ItemStack(item));
                continue;
            }
            NonNullList subItems = NonNullList.func_191196_a();
            try {
                item.func_150895_a(tab, subItems);
            }
            catch (Exception e) {
                Bookshelf.LOG.error("Caught the following exception while getting sub items for {}. It should be reported to that mod's author.", item.getRegistryName().toString());
                Bookshelf.LOG.catching(e);
            }
            items.addAll((Collection)subItems);
        }
        return items;
    }

    public static ItemStack[] getAllItems(Item item) {
        return (ItemStack[])StackUtils.findVariations(item).toArray((Object[])new ItemStack[0]);
    }

    public static String getStackIdentifier(ItemStack stack) {
        return stack != null && !stack.func_190926_b() ? stack.func_77973_b().getRegistryName().toString() : "minecraft:air";
    }

    public static NBTTagCompound getTagCleanly(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }

    public static NonNullList<ItemStack> getAllBlocksForOredict(String oredict) {
        NonNullList subBlocks = NonNullList.func_191196_a();
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            int meta = stack.func_77952_i();
            if (meta == Short.MAX_VALUE) {
                block.func_149666_a(null, subBlocks);
                continue;
            }
            subBlocks.add((Object)stack);
        }
        return subBlocks;
    }
}

