/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class EnchantmentUtils {
    private EnchantmentUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isItemEnchantable(ItemStack itemStack) {
        return itemStack.func_77973_b().getItemEnchantability(itemStack) > 0 && (itemStack.func_77973_b() == Items.field_151122_aG || itemStack.func_77973_b() == Items.field_151134_bR || itemStack.func_77956_u());
    }

    public static int getExperienceFromLevel(int level) {
        return (int)(level < 16 ? (float)(17 * level) : (level > 15 && level < 31 ? 1.5f * (float)(level * level) - 29.5f * (float)level + 360.0f : 3.5f * (float)(level * level) - 151.5f * (float)level + 2220.0f));
    }

    public static int getExperienceToLevel(int startingLevel, int destinationLevel) {
        return EnchantmentUtils.getExperienceFromLevel(destinationLevel) - EnchantmentUtils.getExperienceFromLevel(startingLevel);
    }

    public static int getLevelsFromExperience(int exp) {
        int currentLevel = 0;
        float levelCap = EnchantmentUtils.getExperienceToLevel(currentLevel, currentLevel + 1);
        int currentExp = exp;
        while ((float)currentExp >= levelCap) {
            currentExp = (int)((float)currentExp - levelCap);
            levelCap = EnchantmentUtils.getExperienceToLevel(++currentLevel, currentLevel + 1);
        }
        return currentLevel;
    }

    public static boolean areEnchantmentsCompatible(Enchantment firstEnchantment, Enchantment secondEnchantment) {
        return firstEnchantment.func_191560_c(secondEnchantment);
    }

    public static String getExpForDisplay(int xp) {
        int levels = EnchantmentUtils.getLevelsFromExperience(xp);
        return levels > 0 ? levels + "L" : xp + "xp";
    }

    public static float getEnchantingPower(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        float power = 0.0f;
        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                if (zOffset == 0 && xOffset == 0 || !world.func_175623_d(new BlockPos(x + xOffset, y, z + zOffset)) || !world.func_175623_d(new BlockPos(x + xOffset, y + 1, z + zOffset))) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset * 2, y, z + zOffset * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset * 2, y + 1, z + zOffset * 2));
                if (xOffset == 0 || zOffset == 0) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset * 2, y, z + zOffset));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset * 2, y + 1, z + zOffset));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset, y, z + zOffset * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)new BlockPos(x + xOffset, y + 1, z + zOffset * 2));
            }
        }
        return power;
    }
}

