/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraftforge.common.util.EnumHelper;

public final class BannerUtils {
    private BannerUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static ItemStack createBanner(EnumDyeColor baseColor, NBTTagList patterns) {
        return ItemBanner.func_190910_a((EnumDyeColor)baseColor, (NBTTagList)patterns);
    }

    public static NBTTagList createPatternList(BannerLayer ... layers) {
        NBTTagList patterns = new NBTTagList();
        for (BannerLayer layer : layers) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Pattern", layer.pattern.func_190993_b());
            tag.func_74768_a("Color", layer.color.func_176767_b());
            patterns.func_74742_a((NBTBase)tag);
        }
        return patterns;
    }

    public static BannerPattern addBasicPattern(String name, String id) {
        Class[] paramTypes = new Class[]{String.class, String.class};
        Object[] paramValues = new Object[]{name, id};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static BannerPattern addCraftingPattern(String name, String id, ItemStack craftingStack) {
        Class[] paramTypes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] paramValues = new Object[]{name, id, craftingStack};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static BannerPattern addDyePattern(String name, String id, String craftingTop, String craftingMid, String craftingBot) {
        Class[] paramTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        Object[] paramValues = new Object[]{name, id, craftingTop, craftingMid, craftingBot};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static class BannerLayer {
        private final BannerPattern pattern;
        private final EnumDyeColor color;

        public BannerLayer(BannerPattern pattern, EnumDyeColor color) {
            this.pattern = pattern;
            this.color = color;
        }

        public BannerPattern getPattern() {
            return this.pattern;
        }

        public EnumDyeColor getColor() {
            return this.color;
        }
    }
}

