/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import net.darkhax.bookshelf.block.IColorfulBlock;
import net.darkhax.bookshelf.block.ITileEntityBlock;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.LootBuilder;
import net.darkhax.bookshelf.registry.IAutoRegistry;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AutoRegistry
implements IAutoRegistry {
    private final RegistryHelper helper;

    public AutoRegistry(RegistryHelper helper) {
        this.helper = helper;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : this.helper.getBlocks()) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (ITileEntityBlock provider : this.helper.getTileProviders()) {
            if (!(provider instanceof Block)) continue;
            GameRegistry.registerTileEntity(provider.getTileEntityClass(), (String)((Block)provider).getRegistryName().toString().replace(":", ".").replace("_", "."));
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : this.helper.getItems()) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public void registerEntitys(RegistryEvent.Register<EntityEntry> event) {
        for (EntityEntryBuilder<? extends Entity> entry : this.helper.getEntities()) {
            event.getRegistry().register((IForgeRegistryEntry)entry.build());
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent sound : this.helper.getSounds()) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (IRecipe recipe : this.helper.getRecipes()) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
    }

    @SubscribeEvent
    public void onTableLoaded(LootTableLoadEvent event) {
        for (LootBuilder builder : this.helper.getLootTableEntries().get((Object)event.getName())) {
            LootPool pool = event.getTable().getPool(builder.getPool());
            if (pool != null) {
                pool.addEntry((LootEntry)builder.build());
                continue;
            }
            Constants.LOG.info("The mod {} tried to add loot to {} but the pool was not found. {}", this.helper.getModid(), event.getName(), builder.toString());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void modelRegistryEvent(ModelRegistryEvent event) {
        for (Item item : this.helper.getItems()) {
            this.helper.registerInventoryModel(item);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerBlockColor(ColorHandlerEvent.Block event) {
        for (Block block : this.helper.getColoredBlocks()) {
            event.getBlockColors().func_186722_a(((IColorfulBlock)block).getColorHandler(), new Block[]{block});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemColor(ColorHandlerEvent.Item event) {
        for (Block block : this.helper.getColoredBlocks()) {
            IColorfulBlock colorfulBlock = (IColorfulBlock)block;
            if (colorfulBlock.getItemColorHandler() == null) continue;
            event.getItemColors().func_186730_a(colorfulBlock.getItemColorHandler(), new Item[]{Item.func_150898_a((Block)block)});
        }
        for (Item item : this.helper.getColoredItems()) {
            event.getItemColors().func_186730_a(((IColorfulItem)item).getColorHandler(), new Item[]{item});
        }
    }

    @Override
    public RegistryHelper getHelper() {
        return this.helper;
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
        for (ITileEntityBlock provider : this.helper.getTileProviders()) {
            TileEntitySpecialRenderer<?> tesr = provider.getTileRenderer();
            if (tesr == null) continue;
            ClientRegistry.bindTileEntitySpecialRenderer(provider.getTileEntityClass(), tesr);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
    }
}

