/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeSpeciesSelector;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeSpeciesSelector
implements IBiomeSpeciesSelector {
    Species olive;
    Species ironwood;
    HashMap<Integer, IBiomeSpeciesSelector.DecisionProvider> fastTreeLookup = new HashMap();

    public ResourceLocation getName() {
        return new ResourceLocation("rustic", "default");
    }

    public int getPriority() {
        return 3;
    }

    public IBiomeSpeciesSelector.Decision getSpecies(World world, Biome biome, BlockPos pos, IBlockState state, Random rand) {
        IBiomeSpeciesSelector.DecisionProvider select;
        if (biome == null) {
            return new IBiomeSpeciesSelector.Decision();
        }
        int biomeId = Biome.func_185362_a((Biome)biome);
        if (this.fastTreeLookup.containsKey(biomeId)) {
            select = this.fastTreeLookup.get(biomeId);
        } else {
            select = new IBiomeSpeciesSelector.RandomDecision(rand).addUnhandled(50);
            boolean flag = false;
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN))) {
                ((IBiomeSpeciesSelector.RandomDecision)select).addSpecies(this.olive, 2);
                flag = true;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE))) {
                ((IBiomeSpeciesSelector.RandomDecision)select).addSpecies(this.ironwood, 1);
                flag = true;
            }
            if (!flag) {
                select = new IBiomeSpeciesSelector.StaticDecision(new IBiomeSpeciesSelector.Decision());
            }
            this.fastTreeLookup.put(biomeId, select);
        }
        return select.getDecision();
    }

    public void init() {
        this.olive = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("rustic", "olive"));
        this.ironwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("rustic", "ironwood"));
    }
}

