/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.blocks.BlockLeavesRustic;
import rustic.common.blocks.BlockLogRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.compat.dynamictrees.DropCreatorFruit;
import rustic.compat.dynamictrees.DynamicTreesCompat;

public class TreeOlive
extends TreeFamily {
    public TreeOlive() {
        super(new ResourceLocation("rustic", "olive"));
        IBlockState primLog = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.OLIVE));
        this.setPrimitiveLog(primLog, new ItemStack((Block)ModBlocks.LOG, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()));
        DynamicTreesCompat.oliveLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockLeavesRustic && state.func_177229_b((IProperty)BlockLeavesRustic.VARIANT) == BlockPlanksRustic.EnumType.OLIVE);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesOlive(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add(this.getCommonSpecies().getDynamicSapling().func_177230_c());
        return super.getRegisterableBlocks(blockList);
    }

    public class SpeciesOlive
    extends Species {
        SpeciesOlive(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.oliveLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 1.0f);
            this.setDynamicSapling(new BlockDynamicSapling("olivesapling").func_176223_P());
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.PLAINS, 1.05f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruit((Item)ModItems.OLIVES, 18));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
        }
    }
}

