/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.blocks.BlockLeavesRustic;
import rustic.common.blocks.BlockLogRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.compat.dynamictrees.DropCreatorFruit;
import rustic.compat.dynamictrees.DynamicTreesCompat;

public class TreeIronwood
extends TreeFamily {
    public TreeIronwood() {
        super(new ResourceLocation("rustic", "ironwood"));
        IBlockState primLog = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.IRONWOOD));
        this.setPrimitiveLog(primLog, new ItemStack((Block)ModBlocks.LOG, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()));
        DynamicTreesCompat.ironwoodLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockLeavesRustic && state.func_177229_b((IProperty)BlockLeavesRustic.VARIANT) == BlockPlanksRustic.EnumType.IRONWOOD);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesIronwood(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add(this.getCommonSpecies().getDynamicSapling().func_177230_c());
        return super.getRegisterableBlocks(blockList);
    }

    public class SpeciesIronwood
    extends Species {
        SpeciesIronwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.ironwoodLeavesProperties);
            this.setBasicGrowingParameters(0.35f, 14.0f, 4, 4, 1.25f);
            this.setDynamicSapling(new BlockDynamicSapling("ironwoodsapling").func_176223_P());
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruit((Item)ModItems.IRONBERRIES, 48));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        }
    }
}

