/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.book.pages;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.gui.book.GuiBook;
import rustic.common.book.BookCategory;
import rustic.common.book.BookEntry;
import rustic.common.book.BookEntryCategory;
import rustic.common.book.BookPage;

public class BookPageCategory
extends BookPage {
    private final BookCategory category;
    protected List<BookEntry> entries = new ArrayList<BookEntry>();

    public BookPageCategory(BookCategory category, BookEntryCategory entry) {
        super(entry);
        this.category = category;
    }

    @Override
    public void drawScreen(GuiBook gui, int mouseX, int mouseY, float partialTicks) {
        int y = gui.guiTop + 12;
        int x = gui.guiLeft + 146 / 2;
        gui.drawCenteredText(TextFormatting.UNDERLINE + "" + TextFormatting.BOLD + I18n.func_74838_a((String)this.category.getName()), x, y, 0);
    }

    @Override
    public void onOpened(GuiBook gui) {
        gui.addNavButtons();
        int x = gui.guiLeft + 14;
        int y = gui.guiTop + 24;
        for (BookEntry entry : this.entries) {
            gui.getButtonList().add(new EntryLinkButton(gui.nextButtonID(), x, y, 146 - 16 - 14, gui.getFontRenderer(), entry));
            y += gui.getFontRenderer().field_78288_b + 2;
        }
    }

    @Override
    public void onClosed(GuiBook gui) {
        super.onClosed(gui);
    }

    @Override
    public void actionPerformed(GuiBook gui, GuiButton button) {
        if (button instanceof EntryLinkButton) {
            gui.goToEntry(((EntryLinkButton)button).getEntry());
        }
    }

    public BookPageCategory addEntry(BookEntry entry) {
        this.entries.add(entry);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public class EntryLinkButton
    extends GuiButton {
        private int ticksHovered;
        private FontRenderer fontRenderer;
        private final BookEntry entry;

        public EntryLinkButton(int buttonId, int x, int y, int width, FontRenderer fontRenderer, BookEntry entry) {
            super(buttonId, x, y, width, fontRenderer.field_78288_b + 2, entry.getName());
            this.ticksHovered = 0;
            this.fontRenderer = fontRenderer;
            this.entry = entry;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag;
                boolean bl = flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (flag) {
                    if (this.ticksHovered < this.field_146120_f) {
                        ++this.ticksHovered;
                    }
                    int rectWidth = Math.min(this.ticksHovered * 10, this.field_146120_f);
                    EntryLinkButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + rectWidth), (int)(this.field_146129_i + this.field_146121_g), (int)0x40000000);
                } else {
                    this.ticksHovered = 0;
                }
                this.fontRenderer.func_78276_b(I18n.func_74838_a((String)this.field_146126_j), this.field_146128_h + this.fontRenderer.field_78288_b + 2 + 1, this.field_146129_i + 2, 0);
                if (this.entry != null && !this.entry.getIcon().func_190926_b()) {
                    float scale = (float)(this.fontRenderer.field_78288_b + 2) / 16.0f;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.func_74520_c();
                    mc.func_175599_af().func_175042_a(this.entry.getIcon(), (int)((float)this.field_146128_h / scale), (int)((float)this.field_146129_i / scale));
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179121_F();
                }
            }
        }

        public BookEntry getEntry() {
            return this.entry;
        }
    }
}

