/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import rustic.common.blocks.BlockBase;

public class BlockTable
extends BlockBase {
    public static final PropertyBool NW = PropertyBool.func_177716_a((String)"nw");
    public static final PropertyBool NE = PropertyBool.func_177716_a((String)"ne");
    public static final PropertyBool SE = PropertyBool.func_177716_a((String)"se");
    public static final PropertyBool SW = PropertyBool.func_177716_a((String)"sw");
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);

    public BlockTable(String type) {
        super(Material.field_151575_d, "table_" + type);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)NE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SW, (Comparable)Boolean.valueOf(true)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess ba, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateTemp = worldIn.func_180495_p(pos.func_177978_c());
        Block blockTemp = stateTemp.func_177230_c();
        boolean blockNorth = blockTemp instanceof BlockTable;
        stateTemp = worldIn.func_180495_p(pos.func_177968_d());
        blockTemp = stateTemp.func_177230_c();
        boolean blockSouth = blockTemp instanceof BlockTable;
        stateTemp = worldIn.func_180495_p(pos.func_177974_f());
        blockTemp = stateTemp.func_177230_c();
        boolean blockEast = blockTemp instanceof BlockTable;
        stateTemp = worldIn.func_180495_p(pos.func_177976_e());
        blockTemp = stateTemp.func_177230_c();
        boolean blockWest = blockTemp instanceof BlockTable;
        return state.func_177226_a((IProperty)NW, (Comparable)Boolean.valueOf(!blockNorth && !blockWest)).func_177226_a((IProperty)NE, (Comparable)Boolean.valueOf(!blockNorth && !blockEast)).func_177226_a((IProperty)SE, (Comparable)Boolean.valueOf(!blockSouth && !blockEast)).func_177226_a((IProperty)SW, (Comparable)Boolean.valueOf(!blockSouth && !blockWest));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NW, NE, SE, SW});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

