/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.world.WorldGenIronwoodTree;
import rustic.common.world.WorldGenOliveTree;
import rustic.core.Rustic;

public class BlockSaplingRustic
extends BlockBush
implements IGrowable {
    public static final PropertyEnum<BlockPlanksRustic.EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPlanksRustic.EnumType.class);
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockSaplingRustic() {
        this.setRegistryName("sapling");
        this.func_149663_c("rustic.sapling");
        this.func_149647_a(Rustic.farmingTab);
        ItemBlock item = new ItemBlock((Block)this){

            public String func_77667_c(ItemStack stack) {
                IBlockState state = BlockSaplingRustic.this.func_176203_a(stack.func_77960_j());
                return this.func_77658_a() + "_" + state.func_177229_b(BlockPlanksRustic.VARIANT);
            }

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        item.func_77627_a(true);
        item.func_77656_e(0);
        item.setRegistryName(this.getRegistryName());
        GameRegistry.findRegistry(Block.class).register((IForgeRegistryEntry)this);
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)item);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.OLIVE)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185850_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMap custom_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{STAGE}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)custom_mapper);
        for (int i = 0; i < BlockPlanksRustic.EnumType.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + BlockPlanksRustic.EnumType.byMetadata(i).func_176610_l(), "inventory"));
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenAbstractTree worldgenerator = null;
        int i = 0;
        int j = 0;
        switch ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b(VARIANT))) {
            case OLIVE: {
                worldgenerator = new WorldGenOliveTree(true);
                break;
            }
            case IRONWOOD: {
                worldgenerator = new WorldGenIronwoodTree(true);
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos, iblockstate2, 4);
        if (worldgenerator == null || !worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public boolean isTypeAt(World worldIn, BlockPos pos, BlockPlanksRustic.EnumType type) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b(VARIANT) == type;
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockPlanksRustic.EnumType blockplanks$enumtype : BlockPlanksRustic.EnumType.values()) {
            list.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, blockplanks$enumtype.getMetadata()));
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(meta & 7))).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, STAGE});
    }
}

