/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.common.entity.EntityArrow;
import slimeknights.tconstruct.tools.common.entity.EntityBolt;
import slimeknights.tconstruct.tools.common.entity.EntityShuriken;
import slimeknights.tconstruct.tools.ranged.BoltCoreCastingRecipe;
import slimeknights.tconstruct.tools.ranged.item.Arrow;
import slimeknights.tconstruct.tools.ranged.item.Bolt;
import slimeknights.tconstruct.tools.ranged.item.CrossBow;
import slimeknights.tconstruct.tools.ranged.item.LongBow;
import slimeknights.tconstruct.tools.ranged.item.ShortBow;
import slimeknights.tconstruct.tools.ranged.item.Shuriken;

@Pulse(id="TinkerRangedWeapons", description="All the ranged weapons in one handy package", pulsesRequired="TinkerTools", forced=true)
public class TinkerRangedWeapons
extends AbstractToolPulse {
    public static final String PulseId = "TinkerRangedWeapons";
    static final Logger log = Util.getLogger("TinkerRangedWeapons");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ranged.RangedClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static ShortBow shortBow;
    public static LongBow longBow;
    public static CrossBow crossBow;
    public static Arrow arrow;
    public static Bolt bolt;
    public static ToolCore shuriken;
    private static List<Item> DISCOVERED_ARROWS;

    public static List<Item> getDiscoveredArrows() {
        return DISCOVERED_ARROWS;
    }

    @Override
    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        super.registerItems(event);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("arrow"), EntityArrow.class, (String)"arrow", (int)10, (Object)TConstruct.instance, (int)64, (int)1, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("bolt"), EntityBolt.class, (String)"bolt", (int)11, (Object)TConstruct.instance, (int)64, (int)1, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("shuriken"), EntityShuriken.class, (String)"shuriken", (int)12, (Object)TConstruct.instance, (int)64, (int)1, (boolean)false);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Override
    protected void registerTools(IForgeRegistry<Item> registry) {
        shortBow = TinkerRangedWeapons.registerTool(registry, new ShortBow(), "shortbow");
        longBow = TinkerRangedWeapons.registerTool(registry, new LongBow(), "longbow");
        crossBow = TinkerRangedWeapons.registerTool(registry, new CrossBow(), "crossbow");
        arrow = TinkerRangedWeapons.registerTool(registry, new Arrow(), "arrow");
        bolt = TinkerRangedWeapons.registerTool(registry, new Bolt(), "bolt");
        shuriken = TinkerRangedWeapons.registerTool(registry, new Shuriken(), "shuriken");
    }

    @Override
    @Subscribe
    public void init(FMLInitializationEvent event) {
        super.init(event);
        proxy.init();
    }

    @Override
    protected void registerToolBuilding() {
        TinkerRegistry.registerToolCrafting(shortBow);
        TinkerRegistry.registerToolForgeCrafting(longBow);
        TinkerRegistry.registerToolCrafting(arrow);
        TinkerRegistry.registerToolForgeCrafting(crossBow);
        TinkerRegistry.registerToolForgeCrafting(bolt);
        TinkerRegistry.registerToolForgeCrafting(shuriken);
    }

    @Override
    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.discoverArrows();
        TinkerRegistry.registerTableCasting(BoltCoreCastingRecipe.INSTANCE);
    }

    private void discoverArrows() {
        Iterator iter = Item.field_150901_e.iterator();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (arrow != null) {
            builder.add((Object)arrow);
        }
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (!(item instanceof ItemArrow)) continue;
            builder.add((Object)item);
        }
        DISCOVERED_ARROWS = builder.build();
    }

    static {
        DISCOVERED_ARROWS = new ArrayList<Item>();
    }
}

