/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.common.inventory.ContainerSideInventory;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.tileentity.TileCraftingStation;

public class ContainerCraftingStation
extends ContainerTinkerStation<TileCraftingStation> {
    private final EntityPlayer player;
    private final InventoryCraftingPersistent craftMatrix;
    private final InventoryCraftResult craftResult = new InventoryCraftResult();

    public ContainerCraftingStation(InventoryPlayer playerInventory, TileCraftingStation tile) {
        super(tile);
        this.craftMatrix = new InventoryCraftingPersistent((Container)this, (IInventory)tile, 3, 3);
        this.player = playerInventory.field_70458_d;
        this.func_75146_a((Slot)new SlotCrafting(playerInventory.field_70458_d, (InventoryCrafting)this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18));
            }
        }
        TileEntity inventoryTE = null;
        EnumFacing accessDir = null;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te;
            BlockPos neighbor = this.pos.func_177972_a(dir);
            boolean stationPart = false;
            for (Pair tinkerPos : this.tinkerStationBlocks) {
                if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                stationPart = true;
                break;
            }
            if (stationPart || (te = this.world.func_175625_s(neighbor)) == null || te instanceof TileCraftingStation || this.blacklisted(te.getClass().getName())) continue;
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) instanceof IItemHandlerModifiable) {
                inventoryTE = te;
                accessDir = null;
                break;
            }
            if (!te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) || !(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) instanceof IItemHandlerModifiable)) continue;
            inventoryTE = te;
            accessDir = dir.func_176734_d();
            break;
        }
        if (inventoryTE != null) {
            this.addSubContainer((Container)new ContainerSideInventory<Object>(inventoryTE, accessDir, -114, 8, 6), false);
        }
        this.addPlayerInventory(playerInventory, 8, 84);
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    private boolean blacklisted(String name) {
        for (String te : Config.craftingStationBlacklist) {
            if (!name.equals(te)) continue;
            return true;
        }
        return false;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    protected TileEntity detectInventory() {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te;
            BlockPos neighbor = this.pos.func_177972_a(dir);
            boolean stationPart = false;
            for (Pair tinkerPos : this.tinkerStationBlocks) {
                if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                stationPart = true;
                break;
            }
            if (stationPart || (te = this.world.func_175625_s(neighbor)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) || !(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) instanceof IItemHandlerModifiable)) continue;
            return te;
        }
        return null;
    }

    public int getPlayerInventoryStart() {
        return this.playerInventoryStart;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }
}

