/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.client.module;

import com.google.common.collect.Lists;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetSlider;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.common.client.module.GuiWidgetBorder;

public class GuiInfoPanel
extends GuiModule {
    private static int resW = 118;
    private static int resH = 75;
    private static ResourceLocation BACKGROUND = Util.getResource("textures/gui/panel.png");
    private static GuiElement topLeft = new GuiElement(0, 0, 4, 4, 256, 256);
    private static GuiElement topRight = new GuiElement(resW + 4, 0, 4, 4);
    private static GuiElement botLeft = new GuiElement(0, resH + 4, 4, 4);
    private static GuiElement botRight = new GuiElement(resW + 4, resH + 4, 4, 4);
    private static GuiElementScalable top = new GuiElementScalable(4, 0, resW, 4);
    private static GuiElementScalable bot = new GuiElementScalable(4, 4 + resH, resW, 4);
    private static GuiElementScalable left = new GuiElementScalable(0, 4, 4, resH);
    private static GuiElementScalable right = new GuiElementScalable(4 + resW, 4, 4, resH);
    private static GuiElementScalable background = new GuiElementScalable(4, 4, resW, resH);
    private static GuiElement sliderNormal = new GuiElement(0, 83, 3, 5);
    private static GuiElement sliderHover = sliderNormal.shift(GuiInfoPanel.sliderNormal.w, 0);
    private static GuiElementScalable sliderBar = new GuiElementScalable(0, 88, 3, 8);
    private static GuiElement sliderTop = new GuiElement(3, 88, 3, 4);
    private static GuiElement sliderBot = new GuiElement(3, 92, 3, 4);
    private GuiWidgetBorder border = new GuiWidgetBorder();
    private FontRenderer fontRenderer = ClientProxy.fontRenderer;
    private GuiWidgetSlider slider = new GuiWidgetSlider(sliderNormal, sliderHover, sliderHover, sliderTop, sliderBot, sliderBar);
    protected String caption;
    protected List<String> text;
    protected List<String> tooltips;
    private TIntList tooltipLines = new TIntLinkedList();
    public float textScale = 1.0f;

    public GuiInfoPanel(GuiMultiModule parent, Container container) {
        super(parent, container, true, false);
        this.border.borderTop = top;
        this.border.borderBottom = bot;
        this.border.borderLeft = left;
        this.border.borderRight = right;
        this.border.cornerTopLeft = topLeft;
        this.border.cornerTopRight = topRight;
        this.border.cornerBottomLeft = botLeft;
        this.border.cornerBottomRight = botRight;
        this.field_146999_f = resW + 8;
        this.field_147000_g = resH + 8;
        this.caption = "Caption";
        this.text = Lists.newLinkedList();
        this.field_146289_q = this.fontRenderer;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.field_146289_q = this.fontRenderer;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.border.setPosition(this.field_147003_i, this.field_147009_r);
        this.border.setSize(this.field_146999_f, this.field_147000_g);
        this.slider.setPosition(this.guiRight() - this.border.w - 2, this.field_147009_r + this.border.h + 12);
        this.slider.setSize(this.field_147000_g - this.border.h * 2 - 2 - 12);
        this.updateSliderParameters();
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.updateSliderParameters();
    }

    public void setText(String ... text) {
        this.setText(Lists.newArrayList((Object[])text), null);
    }

    public void setText(List<String> text) {
        this.setText(text, null);
    }

    public void setText(List<String> text, List<String> tooltips) {
        if (text != null) {
            text = Lists.newArrayList(text);
            for (int i = 0; i < text.size(); ++i) {
                text.set(i, LocUtils.convertNewlines((String)((String)text.get(i))));
            }
        }
        this.text = text;
        this.updateSliderParameters();
        this.setTooltips(tooltips);
    }

    protected void setTooltips(List<String> tooltips) {
        if (tooltips != null) {
            for (int i = 0; i < tooltips.size(); ++i) {
                tooltips.set(i, LocUtils.convertNewlines((String)tooltips.get(i)));
            }
        }
        this.tooltips = tooltips;
    }

    public boolean hasCaption() {
        return this.caption != null && !this.caption.isEmpty();
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public int calcNeededHeight() {
        int neededHeight = 0;
        if (this.hasCaption()) {
            neededHeight += this.fontRenderer.field_78288_b;
            neededHeight += 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)this.fontRenderer.field_78288_b + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    protected void updateSliderParameters() {
        this.slider.hide();
        int h = this.field_147000_g - 10;
        if (this.calcNeededHeight() <= h) {
            return;
        }
        this.slider.show();
        int neededHeight = this.calcNeededHeight();
        int hiddenRows = (neededHeight - h) / this.fontRenderer.field_78288_b;
        if ((neededHeight - h) % this.fontRenderer.field_78288_b > 0) {
            ++hiddenRows;
        }
        this.slider.setSliderParameters(0, hiddenRows, 1);
    }

    protected List<String> getTotalLines() {
        int w = this.field_146999_f - this.border.w * 2 + 2;
        if (!this.slider.isHidden()) {
            w -= this.slider.width + 3;
        }
        w = (int)((float)w / this.textScale);
        LinkedList lines = Lists.newLinkedList();
        this.tooltipLines.clear();
        for (String line : this.text) {
            this.tooltipLines.add(lines.size());
            if (line == null || line.isEmpty()) {
                lines.add("");
                continue;
            }
            lines.addAll(this.fontRenderer.func_78271_c(line, w));
        }
        return lines;
    }

    public GuiInfoPanel wood() {
        this.shift(resW + 8, 0);
        this.shiftSlider(6, 0);
        return this;
    }

    public GuiInfoPanel metal() {
        this.shift(resW + 8, resH + 8);
        this.shiftSlider(12, 0);
        return this;
    }

    private void shift(int xd, int yd) {
        this.border.borderTop = top.shift(xd, yd);
        this.border.borderBottom = bot.shift(xd, yd);
        this.border.borderLeft = left.shift(xd, yd);
        this.border.borderRight = right.shift(xd, yd);
        this.border.cornerTopLeft = topLeft.shift(xd, yd);
        this.border.cornerTopRight = topRight.shift(xd, yd);
        this.border.cornerBottomLeft = botLeft.shift(xd, yd);
        this.border.cornerBottomRight = botRight.shift(xd, yd);
    }

    private void shiftSlider(int xd, int yd) {
        this.slider = new GuiWidgetSlider(sliderNormal.shift(xd, yd), sliderHover.shift(xd, yd), sliderHover.shift(xd, yd), sliderTop.shift(xd, yd), sliderBot.shift(xd, yd), sliderBar.shift(xd, yd));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i;
        if (this.tooltips == null) {
            return;
        }
        if (mouseX < this.field_147003_i || mouseX > this.guiRight()) {
            return;
        }
        if (this.hasTooltips() && mouseX >= this.guiRight() - this.border.w - this.fontRenderer.func_78263_a('?') / 2 && mouseX < this.guiRight() && mouseY > this.field_147009_r + 5 && mouseY < this.field_147009_r + 5 + this.fontRenderer.field_78288_b) {
            int w = MathHelper.func_76125_a((int)(this.field_146294_l - mouseX - 12), (int)10, (int)200);
            this.func_146283_a(this.fontRenderer.func_78271_c(Util.translate("gui.general.hover", new Object[0]), w), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        float y = 5 + this.field_147009_r;
        if (this.hasCaption()) {
            y += (float)(this.fontRenderer.field_78288_b + 3);
        }
        float textHeight = (float)this.fontRenderer.field_78288_b * this.textScale + 0.5f;
        float lowerBound = (float)(this.field_147009_r + this.field_147000_g - 5) / this.textScale;
        int index = -1;
        ListIterator<String> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight > lowerBound)) {
            if ((float)mouseY > y && (float)mouseY <= y + textHeight) {
                index = iter.nextIndex();
                break;
            }
            iter.next();
            y += textHeight;
        }
        if (index < 0) {
            return;
        }
        for (i = 0; this.tooltipLines.size() > i && index > this.tooltipLines.get(i); ++i) {
        }
        if (i >= this.tooltips.size() || this.tooltips.get(i) == null) {
            return;
        }
        int w = MathHelper.func_76125_a((int)(this.field_146294_l - mouseX - 12), (int)0, (int)200);
        if (w < 100) {
            mouseX -= 100 - w;
            w = 100;
        }
        List lines = this.fontRenderer.func_78271_c(this.tooltips.get(i), w);
        this.func_146283_a(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r - lines.size() * this.fontRenderer.field_78288_b / 2);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.border.draw();
        background.drawScaled(this.field_147003_i + 4, this.field_147009_r + 4, this.field_146999_f - 8, this.field_147000_g - 8);
        float y = 5 + this.field_147009_r;
        float x = 5 + this.field_147003_i;
        int color = -986896;
        if (this.hasTooltips()) {
            this.fontRenderer.func_175065_a("?", (float)(this.guiRight() - this.border.w - this.fontRenderer.func_78263_a('?') / 2), (float)(this.field_147009_r + 5), -10526881, false);
        }
        if (this.hasCaption()) {
            int x2 = this.field_146999_f / 2;
            this.fontRenderer.func_175063_a(TextFormatting.UNDERLINE + TextFormatting.func_110646_a((String)this.caption), (float)(this.field_147003_i + (x2 -= this.fontRenderer.func_78256_a(this.caption) / 2)), y, color);
            y += (float)(this.fontRenderer.field_78288_b + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        float textHeight = (float)this.fontRenderer.field_78288_b * this.textScale + 0.5f;
        float lowerBound = (float)(this.field_147009_r + this.field_147000_g - 5) / this.textScale;
        GlStateManager.func_179152_a((float)this.textScale, (float)this.textScale, (float)1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<String> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            String line = iter.next();
            this.fontRenderer.func_175063_a(line, x, y, color);
            y += textHeight;
        }
        GlStateManager.func_179152_a((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.slider.update(mouseX, mouseY, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule(mouseX, mouseY));
        this.slider.draw();
    }
}

