/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.IToolStationDisplay;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.traits.InfiTool;

public abstract class ToolCore
extends TinkersItem
implements IToolStationDisplay {
    public static final int DEFAULT_MODIFIERS = 3;
    public static final String TAG_SWITCHED_HAND_HAX = "SwitchedHand";

    public ToolCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabTools);
        this.setNoRepair();
        TinkerRegistry.registerTool(this);
        this.addCategory(Category.TOOL);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getDurabilityStat(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        int max = this.getMaxDamage(stack);
        super.setDamage(stack, Math.min(max, damage));
        if (this.getDamage(stack) == max) {
            ToolHelper.breakTool(stack, null);
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return super.showDurabilityBar(stack) && !ToolHelper.isBroken(stack);
    }

    public float miningSpeedModifier() {
        return 1.0f;
    }

    public abstract float damagePotential();

    public float damageCutoff() {
        return 15.0f;
    }

    public abstract double attackSpeed();

    public float knockback() {
        return 1.0f;
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        if (player instanceof EntityPlayer) {
            return entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), damage);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), damage);
    }

    protected boolean readyForSpecialAttack(EntityLivingBase player) {
        return player instanceof EntityPlayer && ((EntityPlayer)player).func_184825_o(0.5f) > 0.9f;
    }

    public void reduceDurabilityOnHit(ItemStack stack, EntityPlayer player, float damage) {
        damage = Math.max(1.0f, damage / 10.0f);
        if (!this.hasCategory(Category.WEAPON)) {
            damage *= 2.0f;
        }
        ToolHelper.damageTool(stack, (int)damage, (EntityLivingBase)player);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isEffective(state) || ToolHelper.isToolEffective(stack, state)) {
            return ToolHelper.calcDigSpeed(stack, state);
        }
        return super.func_150893_a(stack, state);
    }

    public boolean isEffective(IBlockState state) {
        return false;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return this.isEffective(state);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!ToolHelper.isBroken(itemstack) && this instanceof IAoeTool && ((IAoeTool)((Object)this)).isAoeHarvestTool()) {
            for (BlockPos extraPos : ((IAoeTool)((Object)this)).getAOEBlocks(itemstack, player.func_130014_f_(), player, pos)) {
                this.breakExtraBlock(itemstack, player.func_130014_f_(), player, extraPos, pos);
            }
        }
        if (DualToolHarvestUtils.shouldUseOffhand((EntityLivingBase)player, pos, player.func_184614_ca())) {
            ItemStack off = player.func_184592_cb();
            this.switchItemsInHands((EntityLivingBase)player);
            NBTTagCompound tag = TagUtil.getTagSafe(off);
            tag.func_74772_a(TAG_SWITCHED_HAND_HAX, player.func_130014_f_().func_82737_E());
            off.func_77982_d(tag);
        }
        return this.breakBlock(itemstack, pos, player);
    }

    protected boolean breakBlock(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    protected void breakExtraBlock(ItemStack tool, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        ToolHelper.breakExtraBlock(tool, world, player, pos, refPos);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return ToolHelper.attackEntity(stack, this, (EntityLivingBase)player, entity);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float speed = ToolHelper.getActualAttackSpeed(stack);
        int time = Math.round(20.0f / speed);
        if (time < target.field_70172_ad / 2) {
            target.field_70172_ad = (target.field_70172_ad + time) / 2;
            target.field_70737_aN = (target.field_70737_aN + time) / 2;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed(stack) - 4.0, 0));
        }
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.func_150307_f(i));
            if (trait == null) continue;
            trait.getAttributeModifiers(slot, stack, (Multimap<String, AttributeModifier>)multimap);
        }
        return multimap;
    }

    @Override
    public List<String> getInformation(ItemStack stack) {
        return this.getInformation(stack, true);
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        if (ToolHelper.isBroken(stack)) {
            tooltips.add("" + TextFormatting.DARK_RED + TextFormatting.BOLD + this.getBrokenTooltip(stack));
        }
        super.getTooltip(stack, tooltips);
    }

    protected String getBrokenTooltip(ItemStack itemStack) {
        return Util.translate("tooltip.tool.broken", new Object[0]);
    }

    @Override
    public void getTooltipDetailed(ItemStack stack, List<String> tooltips) {
        tooltips.addAll(this.getInformation(stack, false));
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        if (this.hasCategory(Category.HARVEST)) {
            info.addHarvestLevel();
            info.addMiningSpeed();
        }
        if (this.hasCategory(Category.LAUNCHER)) {
            info.addDrawSpeed();
            info.addRange();
            info.addProjectileBonusDamage();
        }
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public void getTooltipComponents(ItemStack stack, List<String> tooltips) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        List<PartMaterialType> component = this.getRequiredComponents();
        if (materials.size() < component.size()) {
            return;
        }
        for (int i = 0; i < component.size(); ++i) {
            IToolPart part;
            ItemStack partStack;
            PartMaterialType pmt = component.get(i);
            Material material = materials.get(i);
            Iterator<IToolPart> partIter = pmt.getPossibleParts().iterator();
            if (!partIter.hasNext() || (partStack = (part = partIter.next()).getItemstackWithMaterial(material)) == null) continue;
            tooltips.add(material.getTextColor() + TextFormatting.UNDERLINE + partStack.func_82833_r());
            HashSet usedTraits = Sets.newHashSet();
            for (IMaterialStats stats : material.getAllStats()) {
                if (!pmt.usesStat(stats.getIdentifier())) continue;
                tooltips.addAll(stats.getLocalizedInfo());
                for (ITrait trait : pmt.getApplicableTraitsForMaterial(material)) {
                    if (usedTraits.contains(trait)) continue;
                    tooltips.add(material.getTextColor() + trait.getLocalizedName());
                    usedTraits.add(trait);
                }
            }
            tooltips.add("");
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return TagUtil.hasEnchantEffect(stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        for (int index : this.getRepairParts()) {
            if (index >= materials.size()) continue;
            nameMaterials.add(materials.get(index));
        }
        return Material.getCombinedItemName(super.func_77653_i(stack), nameMaterials);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List<ItemStack>)subItems, new Material[0]);
        }
    }

    protected void addDefaultSubItems(List<ItemStack> subItems, Material ... fixedMaterials) {
        for (Material head : TinkerRegistry.getAllMaterials()) {
            ArrayList<Material> mats = new ArrayList<Material>(this.requiredComponents.length);
            for (int i = 0; i < this.requiredComponents.length; ++i) {
                if (fixedMaterials.length > i && fixedMaterials[i] != null && this.requiredComponents[i].isValidMaterial(fixedMaterials[i])) {
                    mats.add(fixedMaterials[i]);
                    continue;
                }
                mats.add(head);
            }
            ItemStack tool = this.buildItem(mats);
            if (!this.hasValidMaterials(tool)) continue;
            subItems.add(tool);
            if (Config.listAllMaterials) continue;
            break;
        }
    }

    protected void addInfiTool(List<ItemStack> subItems, String name) {
        ItemStack tool = this.getInfiTool(name);
        if (this.hasValidMaterials(tool)) {
            subItems.add(tool);
        }
    }

    protected ItemStack getInfiTool(String name) {
        Object materials = ImmutableList.of((Object)((Object)TinkerMaterials.slime), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.ardite), (Object)((Object)TinkerMaterials.ardite));
        materials = materials.subList(0, this.requiredComponents.length);
        ItemStack tool = this.buildItem((List<Material>)materials);
        tool.func_151001_c(name);
        InfiTool.INSTANCE.apply(tool);
        return tool;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (ToolHelper.isBroken(stack)) {
            return -1;
        }
        if (this.getToolClasses(stack).contains(toolClass)) {
            return ToolHelper.getHarvestLevelStat(stack);
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        if (ToolHelper.isBroken(stack)) {
            return Collections.emptySet();
        }
        return super.getToolClasses(stack);
    }

    public String getIdentifier() {
        return this.getRegistryName().func_110623_a();
    }

    @Override
    public String getLocalizedToolName() {
        return Util.translate(this.func_77658_a() + ".name", new Object[0]);
    }

    public String getLocalizedToolName(Material material) {
        return material.getLocalizedItemName(this.getLocalizedToolName());
    }

    public String getLocalizedDescription() {
        return Util.translate(this.func_77658_a() + ".desc", new Object[0]);
    }

    @Override
    protected int repairCustom(Material material, NonNullList<ItemStack> repairItems) {
        Optional matchOptional = RecipeMatch.of((Item)TinkerTools.sharpeningKit).matches(repairItems);
        if (!matchOptional.isPresent()) {
            return 0;
        }
        RecipeMatch.Match match = (RecipeMatch.Match)matchOptional.get();
        for (ItemStack stacks : match.stacks) {
            if (TinkerTools.sharpeningKit.getMaterial(stacks) == material) continue;
            return 0;
        }
        RecipeMatch.removeMatch(repairItems, (RecipeMatch.Match)match);
        HeadMaterialStats stats = (HeadMaterialStats)material.getStats("head");
        float durability = stats.durability * match.amount * TinkerTools.sharpeningKit.getCost();
        return (int)(durability /= 144.0f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        this.onUpdateTraits(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    protected void onUpdateTraits(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack) {
            isSelected = true;
        }
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (stack != null && entityLiving != null && stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            assert (tag != null);
            if (tag.func_74763_f(TAG_SWITCHED_HAND_HAX) == entityLiving.func_130014_f_().func_82737_E()) {
                tag.func_82580_o(TAG_SWITCHED_HAND_HAX);
                stack.func_77982_d(tag);
                this.switchItemsInHands(entityLiving);
            }
        }
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean effective = this.isEffective(state) || ToolHelper.isToolEffective(stack, worldIn.func_180495_p(pos));
        int damage = effective ? 1 : 2;
        this.afterBlockBreak(stack, worldIn, state, pos, entityLiving, damage, effective);
        return this.hasCategory(Category.TOOL);
    }

    protected void switchItemsInHands(EntityLivingBase entityLiving) {
        ItemStack main = entityLiving.func_184614_ca();
        ItemStack off = entityLiving.func_184592_cb();
        entityLiving.func_184611_a(EnumHand.OFF_HAND, main);
        entityLiving.func_184611_a(EnumHand.MAIN_HAND, off);
    }

    public void afterBlockBreak(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.afterBlockBreak(stack, world, state, pos, player, wasEffective);
        }
        ToolHelper.damageTool(stack, damage, player);
    }

    public RayTraceResult func_77621_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, boolean useLiquids) {
        return super.func_77621_a(worldIn, playerIn, useLiquids);
    }

    protected void preventSlowDown(Entity entityIn, float originalSpeed) {
        TinkerTools.proxy.preventPlayerSlowdown(entityIn, originalSpeed, this);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        if (TagUtil.getResetFlag(newStack)) {
            TagUtil.setResetFlag(newStack, false);
            return true;
        }
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged) {
            return true;
        }
        if (oldStack.func_77962_s() != newStack.func_77962_s()) {
            return true;
        }
        Multimap attributesNew = newStack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        Multimap attributesOld = oldStack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (String key : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)key)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)key).iterator();
            Iterator iter2 = attributesOld.get((Object)key).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((AttributeModifier)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        if (oldStack.func_77973_b() == newStack.func_77973_b() && newStack.func_77973_b() instanceof ToolCore) {
            return !ToolCore.isEqualTinkersItem(oldStack, newStack);
        }
        return !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    protected ToolNBT buildDefaultTag(List<Material> materials) {
        ToolNBT data = new ToolNBT();
        if (materials.size() >= 2) {
            HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
            HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
            data.head(head);
            if (materials.size() >= 3) {
                ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
                data.extra(binding);
            }
            data.handle(handle);
        }
        data.modifiers = 3;
        return data;
    }

    public static boolean isEqualTinkersItem(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null || item1.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (!(item1.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        NBTTagCompound tag1 = TagUtil.getTagSafe(item1);
        NBTTagCompound tag2 = TagUtil.getTagSafe(item2);
        NBTTagList mods1 = TagUtil.getModifiersTagList(tag1);
        NBTTagList mods2 = TagUtil.getModifiersTagList(tag2);
        if (mods1.func_74745_c() != mods1.func_74745_c()) {
            return false;
        }
        for (int i = 0; i < mods1.func_74745_c(); ++i) {
            NBTTagCompound tag = mods1.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.equalModifier(tag, mods2.func_150305_b(i))) continue;
            return false;
        }
        return TagUtil.getBaseMaterialsTagList(tag1).equals((Object)TagUtil.getBaseMaterialsTagList(tag2)) && TagUtil.getBaseModifiersUsed(tag1) == TagUtil.getBaseModifiersUsed(tag2) && TagUtil.getOriginalToolStats(tag1).equals(TagUtil.getOriginalToolStats(tag2));
    }
}

