/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import java.lang.reflect.Field;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.MethodOutput;

public class ZenFieldMethod
implements IJavaMethod {
    private final Field field;
    private final ZenType type;
    private final boolean isSetter;

    public ZenFieldMethod(Field field, ITypeRegistry types, boolean isSetter) {
        this.field = field;
        this.isSetter = isSetter;
        this.type = types.getType(field.getType());
    }

    @Override
    public boolean isStatic() {
        return (this.field.getModifiers() & 8) != 0;
    }

    @Override
    public boolean accepts(int numArguments) {
        return numArguments == (this.isSetter ? 1 : 0);
    }

    @Override
    public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
        return arguments.length == (this.isSetter ? 1 : 0);
    }

    @Override
    public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
        return 0;
    }

    @Override
    public void invokeVirtual(MethodOutput output) {
        if (this.isSetter) {
            output.putField(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
        } else {
            output.getField(this.field.getDeclaringClass(), this.field.getName(), this.field.getType());
        }
    }

    @Override
    public void invokeStatic(MethodOutput output) {
        if (!this.isStatic()) {
            throw new UnsupportedOperationException("Cannot perform static operations on a nonstatic Field");
        }
        if (this.isSetter) {
            output.putStaticField(this.field.getDeclaringClass(), this.field);
        } else {
            output.getStaticField(this.field.getDeclaringClass(), this.field);
        }
    }

    @Override
    public ZenType[] getParameterTypes() {
        ZenType[] zenTypeArray;
        if (this.isSetter) {
            ZenType[] zenTypeArray2 = new ZenType[1];
            zenTypeArray = zenTypeArray2;
            zenTypeArray2[0] = this.type;
        } else {
            zenTypeArray = new ZenType[]{};
        }
        return zenTypeArray;
    }

    @Override
    public ZenType getReturnType() {
        return this.isSetter ? ZenType.VOID : this.type;
    }

    @Override
    public boolean isVarargs() {
        return false;
    }
}

