/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.IterableList;
import stanhebben.zenscript.annotations.IterableMap;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMemberGetter;
import stanhebben.zenscript.annotations.ZenMemberSetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenProperty;
import stanhebben.zenscript.annotations.ZenSetter;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArithmeticUnary;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionCompareGeneric;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAssociative;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.casting.CastingNotNull;
import stanhebben.zenscript.type.casting.CastingRuleNone;
import stanhebben.zenscript.type.casting.CastingRuleNullableStaticMethod;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.iterator.IteratorIterable;
import stanhebben.zenscript.type.iterator.IteratorList;
import stanhebben.zenscript.type.iterator.IteratorMap;
import stanhebben.zenscript.type.iterator.IteratorMapKeys;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.type.natives.ZenFieldMethod;
import stanhebben.zenscript.type.natives.ZenNativeCaster;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.type.natives.ZenNativeOperator;
import stanhebben.zenscript.util.AnyClassWriter;
import stanhebben.zenscript.util.IAnyDefinition;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import stanhebben.zenscript.value.IAny;

public class ZenTypeNative
extends ZenType {
    private static final int ITERATOR_NONE = 0;
    private static final int ITERATOR_ITERABLE = 1;
    private static final int ITERATOR_LIST = 2;
    private static final int ITERATOR_MAP = 3;
    private final Class<?> cls;
    private final String anyName;
    private final String anyName2;
    private final List<ZenTypeNative> implementing;
    private final Map<String, ZenNativeMember> members;
    private final Map<String, ZenNativeMember> staticMembers;
    private final List<ZenNativeCaster> casters;
    private final List<ZenNativeOperator> trinaryOperators;
    private final List<ZenNativeOperator> binaryOperators;
    private final List<ZenNativeOperator> unaryOperators;
    private int iteratorType;
    private String classPkg;
    private String className;
    private Annotation iteratorAnnotation;
    private ZenType iteratorKeyType;
    private ZenType iteratorValueType;

    public ZenTypeNative(Class<?> cls) {
        this.cls = cls;
        this.members = new HashMap<String, ZenNativeMember>();
        this.staticMembers = new HashMap<String, ZenNativeMember>();
        this.casters = new ArrayList<ZenNativeCaster>();
        this.trinaryOperators = new ArrayList<ZenNativeOperator>();
        this.binaryOperators = new ArrayList<ZenNativeOperator>();
        this.unaryOperators = new ArrayList<ZenNativeOperator>();
        this.implementing = new ArrayList<ZenTypeNative>();
        this.anyName2 = cls.getName() + "Any";
        this.anyName = this.anyName2.replace('.', '/');
    }

    public void complete(ITypeRegistry types) {
        int iterator = 0;
        Annotation _iteratorAnnotation = null;
        String _classPkg = this.cls.getPackage().getName().replace('/', '.');
        String _className = this.cls.getSimpleName();
        boolean fully = false;
        LinkedList<ZenTypeNative> todo = new LinkedList<ZenTypeNative>();
        todo.add(this);
        this.addSubtypes(todo, types);
        Annotation[] clsAnnotations = this.cls.getAnnotations();
        for (Annotation annotation : clsAnnotations) {
            if (annotation instanceof ZenClass) {
                String value = ((ZenClass)annotation).value();
                int dot = value.lastIndexOf(46);
                if (dot < 0) {
                    _classPkg = null;
                    _className = value;
                } else {
                    _classPkg = value.substring(0, dot);
                    _className = value.substring(dot + 1);
                }
            }
            if (annotation instanceof IterableSimple) {
                iterator = 1;
                _iteratorAnnotation = annotation;
                if (!Iterable.class.isAssignableFrom(this.cls)) {
                    // empty if block
                }
            }
            if (annotation instanceof IterableList) {
                iterator = 2;
                _iteratorAnnotation = annotation;
                if (!List.class.isAssignableFrom(this.cls)) {
                    // empty if block
                }
            }
            if (!(annotation instanceof IterableMap)) continue;
            iterator = 3;
            _iteratorAnnotation = annotation;
            if (Map.class.isAssignableFrom(this.cls)) continue;
        }
        for (Method method : this.cls.getMethods()) {
            boolean isMethod = fully;
            String methodName = method.getName();
            for (Annotation annotation : method.getAnnotations()) {
                String name;
                if (annotation instanceof ZenCaster) {
                    this.casters.add(new ZenNativeCaster(JavaMethod.get(types, method)));
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenGetter) {
                    ZenGetter getterAnnotation = (ZenGetter)annotation;
                    this.checkGetter(method, this.cls);
                    String string = name = getterAnnotation.value().length() == 0 ? method.getName() : getterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenNativeMember());
                    }
                    JavaMethod javaMethod = new JavaMethod(method, types);
                    this.members.get(name).setGetter(javaMethod);
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenSetter) {
                    ZenSetter setterAnnotation = (ZenSetter)annotation;
                    this.checkSetter(method, this.cls);
                    String string = name = setterAnnotation.value().length() == 0 ? method.getName() : setterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenNativeMember());
                    }
                    this.members.get(name).setSetter(new JavaMethod(method, types));
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenMemberGetter) {
                    this.binaryOperators.add(new ZenNativeOperator(OperatorType.MEMBERGETTER, new JavaMethod(method, types)));
                    continue;
                }
                if (annotation instanceof ZenMemberSetter) {
                    this.trinaryOperators.add(new ZenNativeOperator(OperatorType.MEMBERSETTER, new JavaMethod(method, types)));
                    continue;
                }
                if (annotation instanceof ZenOperator) {
                    ZenOperator operatorAnnotation = (ZenOperator)annotation;
                    switch (operatorAnnotation.value()) {
                        case NEG: 
                        case NOT: {
                            if (method.getParameterTypes().length != 0) break;
                            this.unaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(method, types)));
                            break;
                        }
                        case ADD: 
                        case SUB: 
                        case CAT: 
                        case MUL: 
                        case DIV: 
                        case MOD: 
                        case AND: 
                        case OR: 
                        case XOR: 
                        case INDEXGET: 
                        case RANGE: 
                        case CONTAINS: 
                        case COMPARE: 
                        case EQUALS: {
                            if (method.getParameterTypes().length != 1) break;
                            this.binaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(method, types)));
                            break;
                        }
                        case INDEXSET: {
                            if (method.getParameterTypes().length != 2) break;
                            this.trinaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(method, types)));
                        }
                    }
                    isMethod = false;
                    continue;
                }
                if (!(annotation instanceof ZenMethod)) continue;
                isMethod = true;
                ZenMethod methodAnnotation = (ZenMethod)annotation;
                if (methodAnnotation.value().length() <= 0) continue;
                methodName = methodAnnotation.value();
            }
            if (!isMethod) continue;
            if ((method.getModifiers() & 8) > 0) {
                if (!this.staticMembers.containsKey(methodName)) {
                    this.staticMembers.put(methodName, new ZenNativeMember());
                }
                this.staticMembers.get(methodName).addMethod(new JavaMethod(method, types));
                continue;
            }
            if (!this.members.containsKey(methodName)) {
                this.members.put(methodName, new ZenNativeMember());
            }
            this.members.get(methodName).addMethod(new JavaMethod(method, types));
        }
        for (Field field : this.cls.getFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                ZenFieldMethod setterMethod;
                String setterName;
                if (!(annotation instanceof ZenProperty)) continue;
                ZenProperty zenProperty = (ZenProperty)annotation;
                String propertyName = zenProperty.value();
                if (propertyName.isEmpty()) {
                    propertyName = field.getName();
                }
                String methodEnding = propertyName.substring(0, 1).toUpperCase(Locale.US) + propertyName.substring(1);
                String getterName = zenProperty.getter();
                if (getterName.isEmpty()) {
                    getterName = field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE) ? "is" + methodEnding : "get" + methodEnding;
                }
                if ((setterName = zenProperty.setter()).isEmpty()) {
                    setterName = "set" + methodEnding;
                }
                this.members.putIfAbsent(propertyName, new ZenNativeMember());
                try {
                    Method getterMethod = this.cls.getMethod(getterName, new Class[0]);
                    this.checkGetter(getterMethod, this.cls);
                    this.members.get(propertyName).setGetter(new JavaMethod(getterMethod, types));
                }
                catch (NoSuchMethodException e) {
                    setterMethod = new ZenFieldMethod(field, types, false);
                    this.members.get(propertyName).setGetter(setterMethod);
                    this.members.putIfAbsent(getterName, new ZenNativeMember());
                    this.members.get(getterName).addMethod(setterMethod);
                }
                try {
                    Method setterMethod2 = this.cls.getMethod(setterName, field.getType());
                    this.checkSetter(setterMethod2, this.cls);
                    this.members.get(propertyName).setSetter(new JavaMethod(setterMethod2, types));
                }
                catch (NoSuchMethodException e) {
                    setterMethod = new ZenFieldMethod(field, types, true);
                    this.members.get(propertyName).setSetter(setterMethod);
                    this.members.putIfAbsent(setterName, new ZenNativeMember());
                    this.members.get(setterName).addMethod(setterMethod);
                }
            }
        }
        this.iteratorType = iterator;
        this.iteratorAnnotation = _iteratorAnnotation;
        this.classPkg = _classPkg;
        this.className = _className;
    }

    private void checkGetter(Method method, Class cls) {
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new RuntimeException("ZenGetter needs a non Void returntype - " + cls.getName() + "." + method.getName());
        }
        if (method.getParameterCount() > 0) {
            throw new RuntimeException("ZenGetter may not have any parameters - " + cls.getName() + "." + method.getName());
        }
    }

    private void checkSetter(Method method, Class cls) {
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("ZenSetter must have exactly one parameter - " + cls.getName() + "." + method.getName());
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new RuntimeException("ZenSetter must have a void return type");
        }
    }

    public Class getNativeClass() {
        return this.cls;
    }

    public void completeIterators(IEnvironmentGlobal environment) {
        Annotation annotation;
        if (this.iteratorAnnotation instanceof IterableSimple) {
            annotation = (IterableSimple)this.iteratorAnnotation;
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
        if (this.iteratorAnnotation instanceof IterableList) {
            annotation = (IterableList)this.iteratorAnnotation;
            this.iteratorKeyType = ZenTypeInt.INSTANCE;
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
        if (this.iteratorAnnotation instanceof IterableMap) {
            annotation = (IterableMap)this.iteratorAnnotation;
            this.iteratorKeyType = ZenType.parse(annotation.key(), environment);
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal global) {
        if (!global.containsClass(this.anyName2)) {
            global.putClass(this.anyName2, new byte[0]);
        }
        return this.anyName;
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        ZenNativeMember member = this.members.get(name);
        if (member == null) {
            for (ZenTypeNative type : this.implementing) {
                if (!type.members.containsKey(name)) continue;
                member = type.members.get(name);
                break;
            }
        }
        if (member == null) {
            Expression evalue = value.eval(environment);
            IPartialExpression member2 = this.memberExpansion(position, environment, evalue, name);
            if (member2 == null) {
                ZenTypeNative type;
                Iterator<ZenTypeNative> iterator = this.implementing.iterator();
                while (iterator.hasNext() && (member2 = (type = iterator.next()).memberExpansion(position, environment, evalue, name)) == null) {
                }
            }
            if (member2 == null) {
                if (this.hasBinary(STRING, OperatorType.MEMBERGETTER)) {
                    return this.binary(position, environment, value.eval(environment), new ExpressionString(position, name), OperatorType.MEMBERGETTER);
                }
                environment.error(position, "No such member in " + this.getName() + ": " + name);
                return new ExpressionInvalid(position);
            }
            return member2;
        }
        return member.instance(position, environment, value);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        ZenNativeMember member = this.staticMembers.get(name);
        if (member == null) {
            for (ZenTypeNative type : this.implementing) {
                if (!type.staticMembers.containsKey(name)) continue;
                member = type.staticMembers.get(name);
                break;
            }
        }
        if (member == null) {
            IPartialExpression member2 = this.staticMemberExpansion(position, environment, name);
            if (member2 == null) {
                ZenTypeNative type;
                Iterator<ZenTypeNative> iterator = this.implementing.iterator();
                while (iterator.hasNext() && (member2 = (type = iterator.next()).staticMemberExpansion(position, environment, name)) == null) {
                }
            }
            if (member2 == null) {
                environment.error(position, "No such static member in " + this.getName() + ": " + name);
                return new ExpressionInvalid(position);
            }
            return member2;
        }
        return member.instance(position, environment);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        this.completeIterators(methodOutput);
        switch (this.iteratorType) {
            case 0: {
                break;
            }
            case 1: {
                if (numValues == 1) {
                    return new IteratorIterable(methodOutput.getOutput(), this.iteratorValueType);
                }
                if (numValues != 2) break;
                return new IteratorList(methodOutput.getOutput(), this.iteratorValueType);
            }
            case 3: {
                if (numValues == 1) {
                    return new IteratorMapKeys(methodOutput.getOutput(), new ZenTypeAssociative(this.iteratorValueType, this.iteratorKeyType));
                }
                if (numValues != 2) break;
                return new IteratorMap(methodOutput.getOutput(), new ZenTypeAssociative(this.iteratorValueType, this.iteratorKeyType));
            }
            case 2: {
                if (numValues == 1) {
                    return new IteratorIterable(methodOutput.getOutput(), this.iteratorValueType);
                }
                if (numValues != 2) break;
                return new IteratorList(methodOutput.getOutput(), this.iteratorValueType);
            }
        }
        return null;
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        if (this.cls.getSuperclass() != null) {
            ZenType superType = environment.getType(this.cls.getSuperclass());
            rules.registerCastingRule(superType, new CastingRuleNone(this, superType));
            superType.constructCastingRules(environment, rules, followCasters);
        }
        for (Class<?> iface : this.cls.getInterfaces()) {
            ZenType ifaceType = environment.getType(iface);
            rules.registerCastingRule(ifaceType, new CastingRuleNone(this, ifaceType));
            ifaceType.constructCastingRules(environment, rules, followCasters);
        }
        if (followCasters) {
            for (ZenNativeCaster caster : this.casters) {
                caster.constructCastingRule(rules);
            }
            TypeExpansion expansion = environment.getExpansion(this.getName());
            if (expansion != null) {
                expansion.constructCastingRules(environment, rules);
            }
        }
        rules.registerCastingRule(BOOL, new CastingNotNull(this));
        rules.registerCastingRule(ANY, new CastingRuleNullableStaticMethod(JavaMethod.getStatic(this.getAnyClassName(environment), "valueOf", ANY, this)));
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return type == this || this.canCastImplicit(type, environment) || type.canCastExplicit(this, environment);
    }

    @Override
    public Class toJavaClass() {
        return this.cls;
    }

    @Override
    public Type toASMType() {
        return Type.getType(this.cls);
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(this.cls);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        for (ZenNativeOperator unaryOperator : this.unaryOperators) {
            if (unaryOperator.getOperator() != operator) continue;
            return new ExpressionCallVirtual(position, environment, unaryOperator.getMethod(), value, new Expression[0]);
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasTernary(this, operator)) continue;
            return parent.unary(position, environment, value, operator);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        for (ZenNativeOperator binaryOperator : this.binaryOperators) {
            if (binaryOperator.getOperator() != operator) continue;
            return new ExpressionCallVirtual(position, environment, binaryOperator.getMethod(), left, right);
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasBinary(right.getType(), operator)) continue;
            return parent.binary(position, environment, left, right, operator);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        for (ZenNativeOperator trinaryOperator : this.trinaryOperators) {
            if (trinaryOperator.getOperator() != operator) continue;
            return new ExpressionCallVirtual(position, environment, trinaryOperator.getMethod(), first, second, third);
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasTernary(third.getType(), operator)) continue;
            return parent.trinary(position, environment, first, second, third, operator);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        if (type == CompareType.EQ || type == CompareType.NE) {
            for (ZenNativeOperator binaryOperator : this.binaryOperators) {
                if (binaryOperator.getOperator() != OperatorType.EQUALS) continue;
                ExpressionCallVirtual result = new ExpressionCallVirtual(position, environment, binaryOperator.getMethod(), left, right);
                if (type == CompareType.EQ) {
                    return result;
                }
                return new ExpressionArithmeticUnary(position, OperatorType.NOT, result);
            }
        }
        return new ExpressionCompareGeneric(position, this.binary(position, environment, left, right, OperatorType.COMPARE), type);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ZenType[] predictCallTypes(int numArguments) {
        return new ZenType[numArguments];
    }

    private boolean hasBinary(ZenType type, OperatorType operator) {
        for (ZenNativeOperator binaryOperator : this.binaryOperators) {
            if (binaryOperator.getOperator() != operator) continue;
            return true;
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasBinary(type, operator)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTernary(ZenType type, OperatorType operator) {
        for (ZenNativeOperator ternaryOperator : this.trinaryOperators) {
            if (ternaryOperator.getOperator() != operator) continue;
            return true;
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasTernary(type, operator)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnary(ZenType type, OperatorType operator) {
        for (ZenNativeOperator unaryOperator : this.unaryOperators) {
            if (unaryOperator.getOperator() != operator) continue;
            return true;
        }
        for (ZenTypeNative parent : this.implementing) {
            if (!parent.hasUnary(type, operator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.classPkg + '.' + this.className;
    }

    @Override
    public String toString() {
        return "ZenTypeNative: " + this.getName();
    }

    public List<String> dumpTypeInfo() {
        ArrayList<String> stringList = new ArrayList<String>();
        this.members.forEach((s, zenNativeMember) -> {
            stringList.add("Members: " + s);
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                stringList.add("\t" + iJavaMethod.toString());
            }
            if (zenNativeMember.getGetter() != null) {
                stringList.add("Getter: " + zenNativeMember.getGetter().toString());
            }
            if (zenNativeMember.getSetter() != null) {
                stringList.add("Setter: " + zenNativeMember.getSetter().toString());
            }
        });
        this.staticMembers.forEach((s, zenNativeMember) -> {
            stringList.add("Static Members: " + s);
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                stringList.add("\t" + iJavaMethod.toString());
            }
            if (zenNativeMember.getGetter() != null) {
                stringList.add("Static Getter: " + zenNativeMember.getGetter().toString());
            }
            if (zenNativeMember.getSetter() != null) {
                stringList.add("Static Setter: " + zenNativeMember.getSetter().toString());
            }
        });
        return stringList;
    }

    public Map<String, ZenNativeMember> getMembers() {
        return this.members;
    }

    public Map<String, ZenNativeMember> getStaticMembers() {
        return this.staticMembers;
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    private void addSubtypes(Queue<ZenTypeNative> todo, ITypeRegistry types) {
        while (!todo.isEmpty()) {
            ZenType type;
            ZenTypeNative current = todo.poll();
            if (current.cls.getSuperclass() != Object.class && (type = types.getType(current.cls.getSuperclass())) instanceof ZenTypeNative) {
                todo.offer((ZenTypeNative)type);
                this.implementing.add((ZenTypeNative)type);
            }
            for (Class<?> iface : current.cls.getInterfaces()) {
                ZenType type2 = types.getType(iface);
                if (!(type2 instanceof ZenTypeNative)) continue;
                todo.offer((ZenTypeNative)type2);
                this.implementing.add((ZenTypeNative)type2);
            }
        }
    }

    private class AnyNativeDefinition
    implements IAnyDefinition {
        private final IEnvironmentGlobal environment;

        public AnyNativeDefinition(IEnvironmentGlobal environment) {
            this.environment = environment;
        }

        @Override
        public void defineMembers(ClassVisitor output) {
            output.visitField(2, "value", "F", null, null);
            MethodOutput valueOf = new MethodOutput(output, 9, "valueOf", "(F)" + ZenTypeUtil.signature(IAny.class), null, null);
            valueOf.start();
            valueOf.newObject(ZenTypeNative.this.anyName2);
            valueOf.dup();
            valueOf.load(ZenTypeNative.this.toASMType(), 0);
            valueOf.construct(ZenTypeNative.this.anyName2, "L" + ZenTypeNative.this.cls.getName() + ";");
            valueOf.returnObject();
            valueOf.end();
            MethodOutput constructor = new MethodOutput(output, 1, "<init>", "(L" + ZenTypeNative.this.cls.getName() + ";)V", null, null);
            constructor.start();
            constructor.loadObject(0);
            constructor.invokeSpecial(ZenTypeUtil.internal(Object.class), "<init>", "()V");
            constructor.loadObject(0);
            constructor.load(Type.FLOAT_TYPE, 1);
            constructor.putField(ZenTypeNative.this.anyName2, "value", "L" + ZenTypeNative.this.cls.getName() + ";");
            constructor.returnType(Type.VOID_TYPE);
            constructor.end();
        }

        @Override
        public void defineStaticCanCastImplicit(MethodOutput output) {
            output.constant(Type.getType((Class)ZenTypeNative.this.cls));
            output.loadObject(1);
            output.invokeVirtual(Class.class, "isAssignableFrom", Boolean.TYPE, Class.class);
            Label lblNotAssignable = new Label();
            output.ifEQ(lblNotAssignable);
            output.iConst1();
            output.returnInt();
            output.label(lblNotAssignable);
            for (ZenNativeCaster caster : ZenTypeNative.this.casters) {
                caster.compileAnyCanCastImplicit(ZenTypeNative.this, output, this.environment, 0);
            }
            TypeExpansion expansion = this.environment.getExpansion(ZenTypeNative.this.getName());
            if (expansion != null) {
                expansion.compileAnyCanCastImplicit(ZenTypeNative.this, output, this.environment, 0);
            }
            output.iConst0();
            output.returnInt();
        }

        @Override
        public void defineStaticAs(MethodOutput output) {
            output.constant(Type.getType((Class)ZenTypeNative.this.cls));
            output.loadObject(1);
            output.invokeVirtual(Class.class, "isAssignableFrom", Boolean.TYPE, Class.class);
            Label lblNotAssignable = new Label();
            output.ifEQ(lblNotAssignable);
            output.loadObject(0);
            output.returnObject();
            output.label(lblNotAssignable);
            for (ZenNativeCaster caster : ZenTypeNative.this.casters) {
                caster.compileAnyCast(ZenTypeNative.this, output, this.environment, 0, 1);
            }
            TypeExpansion expansion = this.environment.getExpansion(ZenTypeNative.this.getName());
            if (expansion != null) {
                expansion.compileAnyCast(ZenTypeNative.this, output, this.environment, 0, 1);
            }
            AnyClassWriter.throwCastException(output, "float", 1);
        }

        @Override
        public void defineNot(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "not");
        }

        @Override
        public void defineNeg(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "negate");
        }

        @Override
        public void defineAdd(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "+");
        }

        @Override
        public void defineSub(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "-");
        }

        @Override
        public void defineCat(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "~");
        }

        @Override
        public void defineMul(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "*");
        }

        @Override
        public void defineDiv(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "/");
        }

        @Override
        public void defineMod(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "%");
        }

        @Override
        public void defineAnd(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "&");
        }

        @Override
        public void defineOr(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "|");
        }

        @Override
        public void defineXor(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "^");
        }

        @Override
        public void defineRange(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "..");
        }

        @Override
        public void defineCompareTo(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "compare");
        }

        @Override
        public void defineContains(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "in");
        }

        @Override
        public void defineMemberGet(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "member get");
        }

        @Override
        public void defineMemberSet(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "member set");
        }

        @Override
        public void defineMemberCall(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "member call");
        }

        @Override
        public void defineIndexGet(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "index get");
        }

        @Override
        public void defineIndexSet(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "index set");
        }

        @Override
        public void defineCall(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "call");
        }

        @Override
        public void defineAsBool(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asBool");
        }

        @Override
        public void defineAsByte(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asByte");
        }

        @Override
        public void defineAsShort(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asShort");
        }

        @Override
        public void defineAsInt(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asInt");
        }

        @Override
        public void defineAsLong(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asLong");
        }

        @Override
        public void defineAsFloat(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asFloat");
        }

        @Override
        public void defineAsDouble(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asDouble");
        }

        @Override
        public void defineAsString(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "asString");
        }

        @Override
        public void defineAs(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "as");
        }

        @Override
        public void defineIs(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "is");
        }

        @Override
        public void defineGetNumberType(MethodOutput output) {
            output.iConst0();
            output.returnInt();
        }

        @Override
        public void defineIteratorSingle(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "iterator");
        }

        @Override
        public void defineIteratorMulti(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "iterator");
        }

        @Override
        public void defineEquals(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "equals");
        }

        @Override
        public void defineHashCode(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, ZenTypeNative.this.getName(), "hashCode");
        }
    }
}

