/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.event.IEventCancelable;
import crafttweaker.api.event.IEventHandle;
import crafttweaker.util.IEventHandler;

public class EventList<T> {
    private EventNode first = null;
    private EventNode last = null;

    public void clear() {
        this.last = null;
        this.first = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEventHandle add(IEventHandler<T> handler) {
        EventNode node = new EventNode(handler, this.last, null);
        EventList eventList = this;
        synchronized (eventList) {
            if (this.first == null) {
                this.first = node;
            }
            if (this.last != null) {
                this.last.next = node;
            }
            this.last = node;
        }
        return node;
    }

    public boolean hasHandlers() {
        return this.first != null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publish(T event) {
        EventNode current;
        EventList eventList = this;
        synchronized (eventList) {
            current = this.first;
        }
        while (current != null) {
            try {
                current.handler.handle(event);
                if (event instanceof IEventCancelable && ((IEventCancelable)event).isCanceled()) {
                    return true;
                }
            }
            catch (Throwable ex) {
                CraftTweakerAPI.logError(ex.getMessage(), ex);
            }
            eventList = this;
            synchronized (eventList) {
                current = current.next;
            }
        }
        return false;
    }

    private class EventNode
    implements IEventHandle {
        private final IEventHandler<T> handler;
        private EventNode next;
        private EventNode prev;

        public EventNode(IEventHandler<T> handler, EventNode prev, EventNode next) {
            this.handler = handler;
            this.prev = prev;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            EventList eventList = EventList.this;
            synchronized (eventList) {
                if (this.prev == null) {
                    EventList.this.first = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next == null) {
                    EventList.this.last = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

