/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mods.jei.actions;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mods.jei.JEIAddonPlugin;
import java.util.Collections;
import net.minecraftforge.fluids.FluidStack;

public class HideFluidAction
implements IAction {
    private final ILiquidStack stack;

    public HideFluidAction(ILiquidStack stack) {
        this.stack = stack;
    }

    @Override
    public void apply() {
        if (this.stack == null) {
            CraftTweakerAPI.logError("Cannot hide null liquids!");
            return;
        }
        FluidStack fluid = CraftTweakerMC.getLiquidStack(this.stack);
        JEIAddonPlugin.itemRegistry.removeIngredientsAtRuntime(FluidStack.class, Collections.singleton(fluid));
    }

    @Override
    public String describe() {
        return "Hiding item in JEI: " + this.stack;
    }
}

