/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.api.block.IBlock;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.api.world.IWorldInfo;
import crafttweaker.api.world.IWorldProvider;
import crafttweaker.mc1120.world.MCBiome;
import crafttweaker.mc1120.world.MCBlockAccess;
import crafttweaker.mc1120.world.MCWorldInfo;
import crafttweaker.mc1120.world.MCWorldProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MCWorld
extends MCBlockAccess
implements IWorld {
    private final World world;

    public MCWorld(World world) {
        super((IBlockAccess)world);
        this.world = world;
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    @Override
    public int getBrightness(IBlockPos pos) {
        return this.world.func_175699_k((BlockPos)pos.getInternal());
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        return CraftTweakerMC.getBlock((IBlockAccess)this.world, x, y, z);
    }

    @Override
    public IBlock getBlock(IBlockPos pos) {
        return CraftTweakerMC.getBlock((IBlockAccess)this.world, pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public IBiome getBiome(Position3f position) {
        return this.getBiome(position.asBlockPos());
    }

    @Override
    public IBiome getBiome(IBlockPos position) {
        return new MCBiome(this.world.func_180494_b((BlockPos)position.getInternal()));
    }

    @Override
    public IWorldInfo getWorldInfo() {
        return new MCWorldInfo(this.world.func_72912_H());
    }

    @Override
    public boolean isRemote() {
        return this.world.field_72995_K;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72896_J();
    }

    @Override
    public boolean isDayTime() {
        return this.world.func_72935_r();
    }

    @Override
    public boolean isSurfaceWorld() {
        return this.world.field_73011_w.func_76569_d();
    }

    @Override
    public long getWorldTime() {
        return this.world.func_82737_E();
    }

    @Override
    public int getMoonPhase() {
        return this.world.func_72853_d();
    }

    @Override
    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public String getDimensionType() {
        return this.world.field_73011_w.func_186058_p().func_186065_b();
    }

    @Override
    public String getWorldType() {
        return this.world.func_175624_G().func_77127_a();
    }

    @Override
    public Object getInternal() {
        return this.world;
    }

    @Override
    public boolean setBlockState(crafttweaker.api.block.IBlockState state, IBlockPos pos) {
        return this.world.func_175656_a((BlockPos)pos.getInternal(), (IBlockState)state.getInternal());
    }

    @Override
    public IWorldProvider getProvider() {
        return new MCWorldProvider(this.world.field_73011_w);
    }
}

