/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.liquid;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import java.util.Objects;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MCLiquidDefinition
implements ILiquidDefinition {
    private final Fluid fluid;

    public MCLiquidDefinition(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public String getName() {
        return this.fluid.getName();
    }

    @Override
    public String getDisplayName() {
        return this.fluid.getLocalizedName(new FluidStack(this.fluid, 1000));
    }

    @Override
    public ILiquidStack asStack(int millibuckets) {
        return new MCLiquidStack(new FluidStack(this.fluid, millibuckets));
    }

    @Override
    public int getLuminosity() {
        return this.fluid.getLuminosity();
    }

    @Override
    public void setLuminosity(int value) {
        CraftTweakerAPI.apply(new ActionSetLuminosity(value));
    }

    @Override
    public int getDensity() {
        return this.fluid.getDensity();
    }

    @Override
    public void setDensity(int density) {
        CraftTweakerAPI.apply(new ActionSetDensity(density));
    }

    @Override
    public int getTemperature() {
        return this.fluid.getTemperature();
    }

    @Override
    public void setTemperature(int temperature) {
        CraftTweakerAPI.apply(new ActionSetTemperature(temperature));
    }

    @Override
    public int getViscosity() {
        return this.fluid.getViscosity();
    }

    @Override
    public void setViscosity(int viscosity) {
        CraftTweakerAPI.apply(new ActionSetViscosity(viscosity));
    }

    @Override
    public boolean isGaseous() {
        return this.fluid.isGaseous();
    }

    @Override
    public void setGaseous(boolean gaseous) {
        CraftTweakerAPI.apply(new ActionSetGaseous(gaseous));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCLiquidDefinition that = (MCLiquidDefinition)o;
        return Objects.equals(this.fluid, that.fluid);
    }

    public int hashCode() {
        return Objects.hash(this.fluid);
    }

    private class ActionSetGaseous
    implements IAction {
        private final boolean oldValue;
        private final boolean newValue;

        public ActionSetGaseous(boolean newValue) {
            this.oldValue = MCLiquidDefinition.this.isGaseous();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setGaseous(this.newValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " gaseous to " + this.newValue;
        }
    }

    private class ActionSetViscosity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetViscosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getViscosity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setViscosity(this.newValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " viscosity to " + this.newValue;
        }
    }

    private class ActionSetTemperature
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetTemperature(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getTemperature();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setTemperature(this.newValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " temperature to " + this.newValue;
        }
    }

    private class ActionSetDensity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetDensity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getDensity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setDensity(this.newValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " density to " + this.newValue;
        }
    }

    private class ActionSetLuminosity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetLuminosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getLuminosity();
            this.newValue = newValue;
        }

        @Override
        public void apply() {
            MCLiquidDefinition.this.fluid.setLuminosity(this.newValue);
        }

        @Override
        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " luminosity to " + this.newValue;
        }
    }
}

