/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.event.PlayerChangedDimensionEvent;
import crafttweaker.api.event.PlayerCraftedEvent;
import crafttweaker.api.event.PlayerLoggedInEvent;
import crafttweaker.api.event.PlayerLoggedOutEvent;
import crafttweaker.api.event.PlayerPickupItemEvent;
import crafttweaker.api.event.PlayerRespawnEvent;
import crafttweaker.api.event.PlayerSmeltedEvent;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.mc1120.brackets.BracketHandlerEntity;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.damage.MCDamageSource;
import crafttweaker.mc1120.entity.MCEntity;
import crafttweaker.mc1120.events.ScriptRunEvent;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.recipes.MCCraftingInventorySquared;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import crafttweaker.mc1120.world.MCWorld;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CommonEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> ev) {
        CraftTweakerAPI.logInfo("CraftTweaker: Building registry");
        BracketHandlerItem.rebuildItemRegistry();
        BracketHandlerLiquid.rebuildLiquidRegistry();
        BracketHandlerEntity.rebuildEntityRegistry();
        BracketHandlerPotion.rebuildRegistry();
        CraftTweakerAPI.logInfo("CraftTweaker: Successfully built item registry");
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Pre());
        CrafttweakerImplementationAPI.load();
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Post());
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (!MCFurnaceManager.fuelMap.isEmpty() && !event.getItemStack().func_190926_b()) {
            for (Map.Entry<IItemStack, Integer> entry : MCFurnaceManager.fuelMap.entrySet()) {
                if (!entry.getKey().matches(CraftTweakerMC.getIItemStack(event.getItemStack()))) continue;
                event.setBurnTime(entry.getValue().intValue());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent ev) {
        CrafttweakerImplementationAPI.events.publishPlayerLoggedIn(new PlayerLoggedInEvent(CraftTweakerMC.getIPlayer(ev.player)));
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        CrafttweakerImplementationAPI.events.publishPlayerRespawn(new PlayerRespawnEvent(CraftTweakerMC.getIPlayer(ev.player)));
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent ev) {
        PlayerPickupItemEvent event = new PlayerPickupItemEvent(CraftTweakerMC.getIPlayer(ev.getEntityPlayer()), CraftTweakerMC.getIItemStack(ev.getItem().func_92059_d()));
        if (CrafttweakerImplementationAPI.events.publishPlayerPickupItem(event)) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerItemCrafted(PlayerEvent.ItemCraftedEvent ev) {
        if (ev.craftMatrix instanceof InventoryCrafting && !MCRecipeManager.transformerRecipes.isEmpty()) {
            MCRecipeManager.transformerRecipes.stream().filter(mcRecipeBase -> mcRecipeBase.func_77569_a((InventoryCrafting)ev.craftMatrix, ev.player.field_70170_p)).forEach(recipe -> recipe.applyTransformers((InventoryCrafting)ev.craftMatrix, CraftTweakerMC.getIPlayer(ev.player)));
        }
        IPlayer iPlayer = CraftTweakerMC.getIPlayer(ev.player);
        if (ev.craftMatrix instanceof InventoryCrafting) {
            CraftingManager.field_193380_a.func_148742_b().stream().filter(key -> ((IRecipe)CraftingManager.field_193380_a.func_82594_a(key)).func_77571_b().func_77969_a(ev.crafting)).forEach(i -> {
                MCRecipeBase recipeBase;
                IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a(i);
                if (recipe instanceof MCRecipeBase && (recipeBase = (MCRecipeBase)recipe).hasRecipeAction()) {
                    recipeBase.getRecipeAction().process(CraftTweakerMC.getIItemStack(ev.crafting), new CraftingInfo(new MCCraftingInventorySquared(ev.craftMatrix, iPlayer), iPlayer.getWorld()), iPlayer);
                }
            });
        }
        if (CrafttweakerImplementationAPI.events.hasPlayerCrafted()) {
            CrafttweakerImplementationAPI.events.publishPlayerCrafted(new PlayerCraftedEvent(iPlayer, CraftTweakerMC.getIItemStack(ev.crafting), new MCCraftingInventorySquared(ev.craftMatrix, iPlayer)));
        }
    }

    @SubscribeEvent
    public void onPlayerItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerSmelted()) {
            CrafttweakerImplementationAPI.events.publishPlayerSmelted(new PlayerSmeltedEvent(CraftTweakerMC.getIPlayer(ev.player), CraftTweakerMC.getIItemStack(ev.smelting)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        CrafttweakerImplementationAPI.events.publishPlayerLoggedOut(new PlayerLoggedOutEvent(CraftTweakerMC.getIPlayer(ev.player)));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent ev) {
        crafttweaker.api.event.PlayerInteractEvent event;
        if (!ev.getWorld().field_72995_K && CrafttweakerImplementationAPI.events.publishPlayerInteract(event = new crafttweaker.api.event.PlayerInteractEvent(CraftTweakerMC.getIPlayer(ev.getEntityPlayer()), new MCWorld(ev.getWorld()), ev.getPos().func_177958_n(), ev.getPos().func_177956_o(), ev.getPos().func_177952_p()))) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent ev) {
        PlayerChangedDimensionEvent event = new PlayerChangedDimensionEvent(CraftTweakerMC.getIPlayer(ev.player), new MCWorld((World)DimensionManager.getWorld((int)ev.fromDim)), new MCWorld((World)DimensionManager.getWorld((int)ev.toDim)));
        CrafttweakerImplementationAPI.events.publishPlayerChangedDimension(event);
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent ev) {
        Entity entity = ev.getEntity();
        IEntityDefinition entityDefinition = CraftTweakerAPI.game.getEntity(EntityList.func_75621_b((Entity)ev.getEntity()));
        if (entityDefinition != null) {
            if (entityDefinition.shouldClearDrops()) {
                ev.getDrops().clear();
            } else if (!entityDefinition.getDropsToRemove().isEmpty()) {
                ArrayList removedDrops = new ArrayList();
                entityDefinition.getDropsToRemove().forEach(drop -> ev.getDrops().forEach(drops -> {
                    if (drop.matches(new MCItemStack(drops.func_92059_d()))) {
                        removedDrops.add(drops);
                    }
                }));
                ev.getDrops().removeAll(removedDrops);
            }
            if (!entityDefinition.getDrops().isEmpty()) {
                Random rand = entity.field_70170_p.field_73012_v;
                entityDefinition.getDrops().forEach(drop -> {
                    if (drop.isPlayerOnly() && !(ev.getSource().func_76346_g() instanceof EntityPlayer)) {
                        return;
                    }
                    if (drop.getChance() > 0.0f && drop.getChance() < 1.0f && rand.nextFloat() > drop.getChance()) {
                        return;
                    }
                    EntityItem item = drop.getMin() == 0 && drop.getMax() == 0 ? new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().getInternal()).func_77946_l()) : new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().withAmount(drop.getRange().getRandom(rand)).getInternal()).func_77946_l());
                    if (item.func_92059_d().func_190916_E() != 0) {
                        ev.getDrops().add(item);
                    }
                });
            }
            if (!entityDefinition.getDropFunctions().isEmpty()) {
                MCEntity ent = new MCEntity(ev.getEntity());
                MCDamageSource dmgSource = new MCDamageSource(ev.getSource());
                entityDefinition.getDropFunctions().stream().map(fun -> fun.handle(ent, dmgSource)).filter(Objects::nonNull).filter(item -> item.getAmount() > 0).map(CraftTweakerMC::getItemStack).map(item -> new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, item)).forEach(ev.getDrops()::add);
            }
        }
    }
}

