/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands.dumpZScommand;

import crafttweaker.annotations.ZenDoc;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.commands.dumpZScommand.TreeNode;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.Pair;

public class DumpZsCommand
extends CraftTweakerCommand {
    private static final String HTML_HEADER = "<!DOCTYPE html>\n<head><link rel=\"stylesheet\" href=\"tree3.css\"> <title>CraftTweaker: ZenScript Language Dump</title></head>";
    private static final String HTML_BODY_START = "<p>CraftTweaker ZenScript language, refer to <a href=\"http://crafttweaker.readthedocs.io/\" target=\"_blank\">this page</a> for more help.</p>";
    private static final String HTML_DIV_START = "<div class=\"css-treeview\"><ul>";
    private static final String HTML_DIV_END = "</ul></div>";
    private static final String HTML_BODY_END = "<p>This File was created using the dumpzs command.</p>";
    private static final Comparator<TreeNode<String>> STRING_TREE_COMPARATOR = (o1, o2) -> ((String)o1.data).compareToIgnoreCase((String)o2.data);
    private int itemCounter = 0;

    public DumpZsCommand() {
        super("dumpzs");
    }

    @Override
    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        TreeNode<String> root = new TreeNode<String>("root");
        System.out.println("args = " + Arrays.toString(args));
        File zsDataFolder = args == null || args.length <= 0 ? new File("crafttweaker_dump") : new File(Strings.join((String[])args, (String)" "));
        if (!zsDataFolder.exists()) {
            zsDataFolder.mkdirs();
        }
        URL inputUrlPNG = this.getClass().getResource("/assets/crafttweaker/icons.png");
        try {
            FileUtils.copyURLToFile((URL)inputUrlPNG, (File)new File(zsDataFolder, "icons.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URL inputUrlCSS = this.getClass().getResource("/assets/crafttweaker/tree3.css");
        try {
            FileUtils.copyURLToFile((URL)inputUrlCSS, (File)new File(zsDataFolder, "tree3.css"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TreeNode<String> bracketNode = root.addChild("Bracket Handlers");
        for (Pair<Integer, IBracketHandler> pair : GlobalRegistry.getPrioritizedBracketHandlers()) {
            bracketNode.addChild(pair.getClass().getName() + ", priority: " + pair.getKey());
        }
        TreeNode<String> types = root.addChild("Types");
        GlobalRegistry.getTypes().getTypeMap().forEach((aClass, zenType) -> {
            TreeNode<String> zsType = types.addChild(zenType.getName());
            zsType.addChild(aClass.getName());
        });
        types.children.sort(STRING_TREE_COMPARATOR);
        TreeNode<String> globals = root.addChild("Globals");
        GlobalRegistry.getGlobals().forEach((s, iZenSymbol) -> {
            TreeNode<String> globalName = globals.addChild((String)s);
            globalName.addChild(iZenSymbol.toString());
        });
        globals.children.sort(STRING_TREE_COMPARATOR);
        TreeNode<String> expansions = root.addChild("Expansions");
        GlobalRegistry.getExpansions().forEach((s, typeExpansion) -> {
            TreeNode<String> exp = expansions.addChild((String)s);
            exp.addChild(typeExpansion.getClass().getName());
        });
        expansions.children.sort(STRING_TREE_COMPARATOR);
        TreeNode<String> symbols = root.addChild("Root (Symbol Package)");
        GlobalRegistry.getRoot().getPackages().forEach((s, zenSymbol) -> this.printZenSymbol((String)s, (IZenSymbol)zenSymbol, symbols));
        this.sortTreeNodes(symbols);
        try {
            List<String> lines = Arrays.asList(HTML_HEADER, HTML_BODY_START, HTML_DIV_START, this.convertToFlatHTMLStrings(root), HTML_DIV_END, HTML_BODY_END);
            Path file = Paths.get(zsDataFolder.getAbsolutePath() + "/tree3.html", new String[0]);
            Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sender.func_145747_a(SpecialMessagesChat.getFileOpenText("Dumped content of the GlobalRegistry to a html file \u00a7r[\u00a76Click here to open\u00a7r]", zsDataFolder.getAbsolutePath() + "/tree3.html"));
    }

    private void sortTreeNodes(TreeNode<String> parentNode) {
        if (parentNode.isLeaf()) {
            return;
        }
        parentNode.children.sort(STRING_TREE_COMPARATOR);
        for (TreeNode<String> treeNode : parentNode.children) {
            this.sortTreeNodes(treeNode);
        }
    }

    @Override
    protected void init() {
        this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct dumpzs", "/ct dumpzs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Dumps the whole ZenScript Registry to the crafttweaker log"));
    }

    private String convertToFlatHTMLStrings(TreeNode<String> root) {
        this.itemCounter = 0;
        StringBuilder sb = new StringBuilder();
        for (TreeNode<String> treeNode : root.children) {
            sb.append(this.createListBodyString(treeNode));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String createListBodyString(TreeNode<String> node) {
        if (node.isLeaf()) {
            return this.createLeaveString(node);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<li><input type=\"checkbox\" id=\"item-").append(this.itemCounter).append("\" /><label for=\"item-").append(this.itemCounter).append("\">").append((String)node.data).append("</label><ul>");
        ++this.itemCounter;
        for (TreeNode<String> treeNode : node.children) {
            sb.append(this.createListBodyString(treeNode));
        }
        sb.append("</ul></li>");
        return sb.toString();
    }

    private String createLeaveString(TreeNode<String> node) {
        if (node.isLeaf()) {
            return "<li>" + (String)node.data + "</li>";
        }
        return "";
    }

    private void printZenSymbol(String s, IZenSymbol zenSymbol, TreeNode<String> node) {
        if (zenSymbol instanceof SymbolPackage) {
            this.printZenSymbolHelper(zenSymbol, node);
        } else {
            TreeNode<String> n = node.addChild(s);
            n.addChild(zenSymbol.toString());
        }
    }

    private void printZenSymbolHelper(IZenSymbol zenSymbol, TreeNode<String> node) {
        if (zenSymbol instanceof SymbolPackage) {
            SymbolPackage symbolPackage = (SymbolPackage)zenSymbol;
            symbolPackage.getPackages().forEach((s1, symbol) -> {
                TreeNode<String> childNode = this.addToTree((IZenSymbol)symbol, node);
                this.printZenSymbolHelper((IZenSymbol)symbol, childNode);
            });
        } else if (zenSymbol instanceof SymbolType || zenSymbol instanceof ZenTypeNative) {
            ZenTypeNative typeNative = null;
            if (zenSymbol instanceof SymbolType) {
                ZenType type = ((SymbolType)zenSymbol).getType();
                if (type instanceof ZenTypeNative) {
                    typeNative = (ZenTypeNative)type;
                }
            } else {
                typeNative = (ZenTypeNative)((Object)zenSymbol);
            }
            if (typeNative != null) {
                this.addTypeNativeToTree(typeNative, node);
            }
        }
    }

    public void addTypeNativeToTree(ZenTypeNative typeNative, TreeNode<String> node) {
        typeNative.getMembers().forEach((s, zenNativeMember) -> {
            TreeNode<String> n;
            TreeNode<String> chNode = node.addChild((String)s);
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                TreeNode<String> n2 = chNode.addChild("Java Method");
                n2.addChild(this.methodToString(iJavaMethod));
            }
            if (zenNativeMember.getGetter() != null) {
                n = chNode.addChild("Getter");
                n.addChild(this.methodToString(zenNativeMember.getGetter()));
            }
            if (zenNativeMember.getSetter() != null) {
                n = chNode.addChild("Setter");
                n.addChild(this.methodToString(zenNativeMember.getSetter()));
            }
        });
        typeNative.getStaticMembers().forEach((s, zenNativeMember) -> {
            TreeNode<String> n;
            TreeNode<String> chNode = node.addChild("[STATIC] " + s);
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                TreeNode<String> n2 = chNode.addChild("Java Method");
                n2.addChild(this.methodToString(iJavaMethod));
            }
            if (zenNativeMember.getGetter() != null) {
                n = chNode.addChild("Getter");
                n.addChild(this.methodToString(zenNativeMember.getGetter()));
            }
            if (zenNativeMember.getSetter() != null) {
                n = chNode.addChild("Setter");
                n.addChild(this.methodToString(zenNativeMember.getSetter()));
            }
        });
    }

    private String methodToString(IJavaMethod javaMethod) {
        if (javaMethod == null) {
            return "";
        }
        if (javaMethod instanceof JavaMethod) {
            Method jm = ((JavaMethod)javaMethod).getMethod();
            StringBuilder sb = new StringBuilder();
            ZenDoc[] doc = (ZenDoc[])jm.getAnnotationsByType(ZenDoc.class);
            if (doc.length > 0) {
                sb.append(this.encaplseInSpan("########", "green"));
                for (ZenDoc zenDoc : doc) {
                    sb.append("<br/>");
                    sb.append(this.encaplseInSpan(zenDoc.value(), "green"));
                }
                sb.append(this.encaplseInSpan("<br/>########<br/>", "green"));
            }
            sb.append(Modifier.toString(jm.getModifiers()));
            sb.append(" ");
            sb.append(this.createHoverText(jm.getReturnType().getName(), jm.getReturnType().getSimpleName()));
            sb.append(" ");
            sb.append(this.encaplseInSpan(jm.getName(), "red"));
            sb.append("(");
            Class<?>[] paras = jm.getParameterTypes();
            Annotation[][] annos = jm.getParameterAnnotations();
            for (int i = 0; i < paras.length; ++i) {
                for (int j = 0; j < annos[i].length; ++j) {
                    sb.append(this.encaplseInSpan("@" + annos[i][j].annotationType().getSimpleName() + " ", "gold"));
                }
                sb.append(this.createHoverText(paras[i].getName(), paras[i].getSimpleName()));
                if (i == paras.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        return javaMethod.toString();
    }

    private String colorClassName(String name) {
        int lastDot = name.lastIndexOf(".");
        if (lastDot > 0) {
            return name.substring(0, lastDot + 1) + this.encaplseInSpan(name.substring(lastDot + 1, name.length()), "DarkOrange");
        }
        return this.encaplseInSpan(name, "DarkOrange");
    }

    private String encaplseInSpan(String value, String color) {
        return "<span style=\"color:" + color + "\">" + value + "</span>";
    }

    private String createHoverText(String hoverText, String mainText) {
        return "<span title=\"" + hoverText + "\">" + mainText + "</span>";
    }

    private TreeNode<String> addToTree(IZenSymbol symbol, TreeNode<String> node) {
        String name = symbol instanceof SymbolPackage ? null : (symbol instanceof SymbolType ? ((SymbolType)symbol).getType().getName() : symbol.toString());
        if (name != null) {
            String[] split;
            for (String s : split = name.split("\\.")) {
                TreeNode<String> childNode = node.findTreeNode((Comparable<String>)((Object)s));
                if (childNode == null) {
                    childNode = node.addChild(s);
                }
                node = childNode;
            }
        }
        return node;
    }
}

