/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.mc1120.commands.Commands;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.commons.lang3.ArrayUtils;

public class CTChatCommand
extends CommandBase {
    public static final String CRAFTTWEAKER_LOG_PATH = new File("crafttweaker.log").getAbsolutePath();
    private static final List<String> aliases = new ArrayList<String>();
    private static final Map<String, CraftTweakerCommand> craftTweakerCommands = new TreeMap<String, CraftTweakerCommand>();

    public static void register(FMLServerStartingEvent ev) {
        Commands.registerCommands();
        ev.registerServerCommand((ICommand)new CTChatCommand());
    }

    public static void sendUsage(ICommandSender sender) {
        sender.func_145747_a(SpecialMessagesChat.EMPTY_TEXTMESSAGE);
        for (Map.Entry<String, CraftTweakerCommand> entry : craftTweakerCommands.entrySet()) {
            for (ITextComponent s : entry.getValue().getDescription()) {
                sender.func_145747_a(s);
            }
            sender.func_145747_a(SpecialMessagesChat.EMPTY_TEXTMESSAGE);
        }
    }

    public static void registerCommand(CraftTweakerCommand command) {
        craftTweakerCommands.put(command.getSubCommandName(), command);
    }

    public String func_71517_b() {
        return "crafttweaker";
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder sb = new StringBuilder();
        sb.append("/crafttweaker ");
        String[] commands = new String[craftTweakerCommands.keySet().size()];
        craftTweakerCommands.keySet().toArray(commands);
        for (int i = 0; i < commands.length; ++i) {
            sb.append(commands[i]);
            if (i == commands.length - 1) continue;
            sb.append(" | ");
        }
        return sb.toString();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length <= 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        if (craftTweakerCommands.containsKey(args[0])) {
            if (sender.func_174793_f() instanceof EntityPlayer) {
                craftTweakerCommands.get(args[0]).executeCommand(server, sender, (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
            } else {
                craftTweakerCommands.get(args[0]).executeCommand(server, sender, (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
            }
        } else {
            sender.func_145747_a(SpecialMessagesChat.getClickableCommandText("\u00a7cNo such command! \u00a76[Click to show help]", "/ct help", true));
        }
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        Set<String> keys = craftTweakerCommands.keySet();
        ArrayList<String> currentPossibleCommands = new ArrayList<String>();
        if (args.length <= 0) {
            return new ArrayList<String>(keys);
        }
        if (args.length == 1) {
            for (String cmd : keys) {
                if (!cmd.startsWith(args[0])) continue;
                currentPossibleCommands.add(cmd);
            }
            return currentPossibleCommands;
        }
        CraftTweakerCommand subCommand = craftTweakerCommands.get(args[0]);
        if (subCommand != null) {
            System.out.println(Arrays.toString(ArrayUtils.subarray((Object[])args, (int)1, (int)args.length)));
            return subCommand.getSubSubCommand(server, sender, (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), targetPos);
        }
        return currentPossibleCommands;
    }

    public int func_82362_a() {
        return 4;
    }

    static {
        aliases.add("ct");
        aliases.add("mt");
        aliases.add("minetweaker");
    }
}

