/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.logger;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.player.IPlayer;
import crafttweaker.runtime.ILogger;
import java.util.ArrayList;
import java.util.List;

public class MTLogger
implements ILogger {
    private final List<ILogger> loggers = new ArrayList<ILogger>();
    private final List<IPlayer> players = new ArrayList<IPlayer>();
    private final List<String> unprocessed = new ArrayList<String>();

    public void addLogger(ILogger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(ILogger logger) {
        this.loggers.remove(logger);
    }

    public void addPlayer(IPlayer player) {
        this.players.add(player);
        if (!this.unprocessed.isEmpty() && !CraftTweakerAPI.noWarn) {
            this.unprocessed.forEach(player::sendChat);
        }
    }

    public void removePlayer(IPlayer player) {
        this.players.remove(player);
    }

    public void clear() {
        this.unprocessed.clear();
    }

    @Override
    public void logCommand(String message) {
        for (ILogger logger : this.loggers) {
            logger.logCommand(message);
        }
    }

    @Override
    public void logInfo(String message) {
        for (ILogger logger : this.loggers) {
            logger.logInfo(message);
        }
    }

    @Override
    public void logWarning(String message) {
        for (ILogger logger : this.loggers) {
            logger.logWarning(message);
        }
        String message2 = "WARNING: " + message;
        if (this.players.isEmpty()) {
            this.unprocessed.add(message2);
        } else if (!CraftTweakerAPI.noWarn) {
            for (IPlayer player : this.players) {
                player.sendChat(message2);
            }
        }
    }

    @Override
    public void logError(String message) {
        this.logError(message, null);
    }

    @Override
    public void logError(String message, Throwable exception) {
        for (ILogger logger : this.loggers) {
            logger.logError(message, exception);
        }
        String message2 = "ERROR: " + message;
        if (this.players.isEmpty()) {
            this.unprocessed.add(message2);
        } else if (!CraftTweakerAPI.noWarn) {
            for (IPlayer player : this.players) {
                player.sendChat(message2);
            }
        }
    }

    @Override
    public void logPlayer(IPlayer player) {
    }
}

