/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.event;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.event.IEventCancelable;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IWorld;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="crafttweaker.event.PlayerUseHoeEvent")
@ZenRegister
public class PlayerUseHoeEvent
implements IEventCancelable {
    private final IPlayer player;
    private final IItemStack item;
    private final IWorld world;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private boolean processed;

    public PlayerUseHoeEvent(IPlayer player, IItemStack item, IWorld blocks, int x, int y, int z) {
        this.player = player;
        this.item = item;
        this.world = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.processed = false;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @ZenMethod
    public void process() {
        this.processed = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="processed")
    public boolean isProcessed() {
        return this.processed;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="item")
    public IItemStack getItem() {
        return this.item;
    }

    @ZenGetter(value="world")
    public IWorld getBlocks() {
        return this.world;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="dimension")
    public int getDimension() {
        return this.world.getDimension();
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.world.getBlock(this.x, this.y, this.z);
    }
}

