/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.event;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.event.IEventCancelable;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IWorld;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="crafttweaker.event.PlayerInteractEvent")
@ZenRegister
public class PlayerInteractEvent
implements IEventCancelable {
    private final IPlayer player;
    private final IWorld world;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private boolean useBlock;
    private boolean useItem;

    public PlayerInteractEvent(IPlayer player, IWorld blocks, int x, int y, int z) {
        this.player = player;
        this.world = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.useBlock = false;
        this.useItem = false;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @ZenMethod
    public void useBlock() {
        this.useBlock = true;
    }

    @ZenMethod
    public void useItem() {
        this.useItem = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="usingBlock")
    public boolean isUsingBlock() {
        return this.useBlock;
    }

    @ZenGetter(value="usingItem")
    public boolean isUsingItem() {
        return this.useItem;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="world")
    public IWorld getWorld() {
        return this.world;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.world.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public int getDimension() {
        return this.world.getDimension();
    }
}

