/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.event;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.event.IEventCancelable;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IWorld;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="crafttweaker.event.PlayerFillBucketEvent")
@ZenRegister
public class PlayerFillBucketEvent
implements IEventCancelable {
    private final IPlayer player;
    private final IWorld world;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private IItemStack result;

    public PlayerFillBucketEvent(IPlayer player, IWorld world, int x, int y, int z) {
        this.player = player;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.result = null;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="result")
    public IItemStack getResult() {
        return this.result;
    }

    @ZenSetter(value="result")
    public void setResult(IItemStack result) {
        this.result = result;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="world")
    public IWorld getWorld() {
        return this.world;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.world.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public int getDimension() {
        return this.world.getDimension();
    }
}

