/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderCrossing;
import cam72cam.immersiverailroading.track.BuilderCubicCurve;
import cam72cam.immersiverailroading.track.BuilderSlope;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.BuilderSwitch;
import cam72cam.immersiverailroading.track.BuilderTurn;
import cam72cam.immersiverailroading.track.BuilderTurnTable;
import cam72cam.immersiverailroading.util.OreHelper;
import cam72cam.immersiverailroading.util.PlacementInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class RailInfo {
    public final World world;
    public final RailSettings settings;
    public final PlacementInfo placementInfo;
    public final PlacementInfo customInfo;
    public final SwitchState switchState;
    public final double tablePos;
    public final String uniqueID;
    public Map<BlockPos, BuilderBase> builders = new HashMap<BlockPos, BuilderBase>();

    public RailInfo(World world, RailSettings settings, PlacementInfo placementInfo, PlacementInfo customInfo, SwitchState switchState, double tablePos) {
        if (customInfo == null) {
            customInfo = placementInfo;
        }
        this.world = world;
        this.settings = settings;
        this.placementInfo = placementInfo;
        this.customInfo = customInfo;
        this.switchState = switchState;
        this.tablePos = tablePos;
        Object[] props = new Object[]{this.settings.type, this.settings.length, this.settings.quarters, this.settings.railBed, this.settings.gauge, this.switchState, this.tablePos, Float.valueOf(this.placementInfo.yaw), this.placementInfo.direction, Float.valueOf(this.customInfo.yaw), this.customInfo.direction};
        String id = Arrays.toString(props);
        if (!placementInfo.placementPosition.equals((Object)customInfo.placementPosition) || this.settings.posType != TrackPositionType.FIXED) {
            id = id + placementInfo.placementPosition;
            id = id + customInfo.placementPosition;
        }
        this.uniqueID = id;
    }

    public RailInfo(World world, ItemStack settings, PlacementInfo placementInfo, PlacementInfo customInfo) {
        this(world, ItemTrackBlueprint.settings(settings), placementInfo, customInfo, SwitchState.NONE, 0.0);
    }

    public RailInfo(World world, BlockPos pos, NBTTagCompound nbt) {
        this(world, new RailSettings(nbt.func_74775_l("settings")), new PlacementInfo(nbt.func_74775_l("placement"), pos), new PlacementInfo(nbt.func_74775_l("custom"), pos), SwitchState.values()[nbt.func_74762_e("switchState")], nbt.func_74769_h("tablePos"));
    }

    public NBTTagCompound toNBT(BlockPos pos) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("settings", (NBTBase)this.settings.toNBT());
        nbt.func_74782_a("placement", (NBTBase)this.placementInfo.toNBT(pos));
        nbt.func_74782_a("custom", (NBTBase)this.customInfo.toNBT(pos));
        nbt.func_74768_a("switchState", this.switchState.ordinal());
        nbt.func_74780_a("tablePos", this.tablePos);
        return nbt;
    }

    public RailInfo clone() {
        return new RailInfo(this.world, this.settings, this.placementInfo, this.customInfo, this.switchState, this.tablePos);
    }

    public RailInfo withLength(int length) {
        RailSettings settings = this.settings.withLength(length);
        return new RailInfo(this.world, settings, this.placementInfo, this.customInfo, this.switchState, this.tablePos);
    }

    public RailInfo withType(TrackItems type) {
        RailSettings settings = this.settings.withType(type);
        return new RailInfo(this.world, settings, this.placementInfo, this.customInfo, this.switchState, this.tablePos);
    }

    public BuilderBase getBuilder(BlockPos pos) {
        if (this.builders.containsKey(pos)) {
            return this.builders.get(pos);
        }
        this.builders.put(pos, this.constructBuilder(pos));
        return this.builders.get(pos);
    }

    private BuilderBase constructBuilder(BlockPos pos) {
        switch (this.settings.type) {
            case STRAIGHT: {
                return new BuilderStraight(this, pos);
            }
            case CROSSING: {
                return new BuilderCrossing(this, pos);
            }
            case SLOPE: {
                return new BuilderSlope(this, pos);
            }
            case TURN: {
                return new BuilderTurn(this, pos);
            }
            case SWITCH: {
                return new BuilderSwitch(this, pos);
            }
            case TURNTABLE: {
                return new BuilderTurnTable(this, pos);
            }
            case CUSTOM: {
                return new BuilderCubicCurve(this, pos);
            }
        }
        return null;
    }

    public BuilderBase getBuilder() {
        return this.getBuilder(BlockPos.field_177992_a);
    }

    public boolean build(EntityPlayer player) {
        BuilderBase builder = this.getBuilder(new BlockPos(this.placementInfo.placementPosition));
        if (player.func_184812_l_() && Config.ConfigDamage.creativePlacementClearsBlocks && !this.world.field_72995_K) {
            builder.clearArea();
        }
        if (builder.canBuild() && !this.world.field_72995_K) {
            if (player.func_184812_l_()) {
                builder.build();
                return true;
            }
            int ties = 0;
            int rails = 0;
            int bed = 0;
            int fill = 0;
            for (ItemStack playerStack : player.field_71071_by.field_70462_a) {
                if (playerStack.func_77973_b() == IRItems.ITEM_RAIL && ItemGauge.get(playerStack) == this.settings.gauge) {
                    rails += playerStack.func_190916_E();
                }
                if (OreHelper.IR_TIE.matches(playerStack, false)) {
                    ties += playerStack.func_190916_E();
                }
                if (this.settings.railBed.func_77973_b() != Items.field_190931_a && this.settings.railBed.func_77973_b() == playerStack.func_77973_b() && this.settings.railBed.func_77960_j() == playerStack.func_77960_j()) {
                    bed += playerStack.func_190916_E();
                }
                if (this.settings.railBedFill.func_77973_b() == Items.field_190931_a || this.settings.railBedFill.func_77973_b() != playerStack.func_77973_b() || this.settings.railBedFill.func_77960_j() != playerStack.func_77960_j()) continue;
                fill += playerStack.func_190916_E();
            }
            boolean isOk = true;
            if (ties < builder.costTies()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_TIES.getMessage(builder.costTies() - ties));
                isOk = false;
            }
            if (rails < builder.costRails()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAILS.getMessage(builder.costRails() - rails));
                isOk = false;
            }
            if (this.settings.railBed.func_77973_b() != Items.field_190931_a && bed < builder.costBed()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAIL_BED.getMessage(builder.costBed() - bed));
                isOk = false;
            }
            if (this.settings.railBedFill.func_77973_b() != Items.field_190931_a && fill < builder.costFill()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAIL_BED_FILL.getMessage(builder.costFill() - fill));
                isOk = false;
            }
            if (!isOk) {
                return false;
            }
            ties = builder.costTies();
            rails = builder.costRails();
            bed = builder.costBed();
            fill = builder.costFill();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (ItemStack playerStack : player.field_71071_by.field_70462_a) {
                ItemStack copy;
                if (playerStack.func_77973_b() == IRItems.ITEM_RAIL && ItemGauge.get(playerStack) == this.settings.gauge) {
                    if (rails > playerStack.func_190916_E()) {
                        rails -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (rails != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(rails);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - rails);
                        rails = 0;
                    }
                }
                if (OreHelper.IR_TIE.matches(playerStack, false)) {
                    if (ties > playerStack.func_190916_E()) {
                        ties -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (ties != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(ties);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - ties);
                        ties = 0;
                    }
                }
                if (this.settings.railBed.func_77973_b() != Items.field_190931_a && this.settings.railBed.func_77973_b() == playerStack.func_77973_b() && this.settings.railBed.func_77960_j() == playerStack.func_77960_j()) {
                    if (bed > playerStack.func_190916_E()) {
                        bed -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (bed != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(bed);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - bed);
                        bed = 0;
                    }
                }
                if (this.settings.railBedFill.func_77973_b() == Items.field_190931_a || this.settings.railBedFill.func_77973_b() != playerStack.func_77973_b() || this.settings.railBedFill.func_77960_j() != playerStack.func_77960_j()) continue;
                if (fill > playerStack.func_190916_E()) {
                    fill -= playerStack.func_190916_E();
                    copy = playerStack.func_77946_l();
                    copy.func_190920_e(playerStack.func_190916_E());
                    playerStack.func_190920_e(0);
                    continue;
                }
                if (fill == 0) continue;
                copy = playerStack.func_77946_l();
                copy.func_190920_e(fill);
                playerStack.func_190920_e(playerStack.func_190916_E() - fill);
                fill = 0;
            }
            builder.setDrops(drops);
            builder.build();
            return true;
        }
        return false;
    }
}

