/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderIterator;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderSwitch
extends BuilderBase
implements IIterableTrack {
    private BuilderIterator turnBuilder;
    private BuilderStraight straightBuilder;
    private final BuilderStraight straightBuilderReal;

    public BuilderSwitch(RailInfo info, BlockPos pos) {
        super(info, pos);
        RailInfo turnInfo = info.withType(info.customInfo.placementPosition.equals((Object)info.placementInfo.placementPosition) ? TrackItems.TURN : TrackItems.CUSTOM);
        RailInfo straightInfo = info.clone();
        this.turnBuilder = (BuilderIterator)turnInfo.getBuilder(pos);
        this.straightBuilder = new BuilderStraight(straightInfo, pos, true);
        double maxOverlap = 0.0;
        this.straightBuilder.positions.retainAll(this.turnBuilder.positions);
        for (Pair straight : this.straightBuilder.positions) {
            maxOverlap = Math.max(maxOverlap, new Vec3d((double)((Integer)straight.getKey()).intValue(), 0.0, (double)((Integer)straight.getValue()).intValue()).func_72433_c());
        }
        straightInfo = straightInfo.withLength((int)Math.ceil(maxOverlap *= 1.2) + 3);
        this.straightBuilder = new BuilderStraight(straightInfo, pos, true);
        this.straightBuilderReal = new BuilderStraight(straightInfo.withType(TrackItems.STRAIGHT), pos, true);
        this.turnBuilder.overrideFlexible = true;
        for (TrackBase turn : this.turnBuilder.tracks) {
            if (!(turn instanceof TrackRail)) continue;
            turn.overrideParent(this.straightBuilder.getParentPos());
        }
        for (TrackBase straight : this.straightBuilder.tracks) {
            if (!(straight instanceof TrackGag)) continue;
            straight.setFlexible();
        }
    }

    @Override
    public List<BuilderBase> getSubBuilders() {
        List<BuilderBase> subTurns = this.turnBuilder.getSubBuilders();
        List<BuilderBase> subStraights = this.straightBuilderReal.getSubBuilders();
        if (subTurns == null && subStraights == null) {
            return null;
        }
        ArrayList<BuilderBase> res = new ArrayList<BuilderBase>();
        if (subTurns == null) {
            res.add(this.turnBuilder);
        } else {
            res.addAll(subTurns);
        }
        if (subStraights == null) {
            res.add(this.straightBuilderReal);
        } else {
            res.addAll(subStraights);
        }
        return res;
    }

    @Override
    public int costTies() {
        return this.straightBuilder.costTies() + this.turnBuilder.costTies();
    }

    @Override
    public int costRails() {
        return this.straightBuilder.costRails() + this.turnBuilder.costRails();
    }

    @Override
    public int costBed() {
        return this.straightBuilder.costBed() + this.turnBuilder.costBed();
    }

    @Override
    public int costFill() {
        return this.straightBuilder.costFill() + this.turnBuilder.costFill();
    }

    @Override
    public void setDrops(List<ItemStack> drops) {
        this.straightBuilder.setDrops(drops);
    }

    @Override
    public boolean canBuild() {
        return this.straightBuilder.canBuild() && this.turnBuilder.canBuild();
    }

    @Override
    public void build() {
        this.straightBuilder.build();
        this.turnBuilder.build();
    }

    @Override
    public void clearArea() {
        this.straightBuilder.clearArea();
        this.turnBuilder.clearArea();
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        List<TrackBase> data = this.straightBuilder.getTracksForRender();
        data.addAll(this.turnBuilder.getTracksForRender());
        return data;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        List<BuilderBase.VecYawPitch> data = this.straightBuilder.getRenderData();
        data.addAll(this.turnBuilder.getRenderData());
        return data;
    }

    public boolean isOnStraight(Vec3d position) {
        for (Vec3d vec3d : this.straightBuilder.getPath(this.info.settings.gauge.scale() / 8.0)) {
            Vec3d vec3d2 = vec3d.func_178787_e(this.info.placementInfo.placementPosition);
            if (!(vec3d2.func_72438_d(position.func_72441_c(0.0, -(position.field_72448_b % 1.0), 0.0)) < this.info.settings.gauge.scale() / 2.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PosStep> getPath(double stepSize) {
        return this.straightBuilder.getPath(stepSize);
    }
}

