/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BuilderIterator
extends BuilderBase
implements IIterableTrack {
    protected HashSet<Pair<Integer, Integer>> positions = new HashSet();

    public BuilderIterator(RailInfo info, BlockPos pos) {
        this(info, pos, false);
    }

    @Override
    public abstract List<PosStep> getPath(double var1);

    public BuilderIterator(RailInfo info, BlockPos pos, boolean endOfTrack) {
        super(info, pos);
        HashMap<Pair, Float> bedHeights = new HashMap<Pair, Float>();
        HashMap<Pair, Float> railHeights = new HashMap<Pair, Float>();
        HashMap<Pair, Integer> yOffset = new HashMap<Pair, Integer>();
        HashSet<Pair> flexPositions = new HashSet<Pair>();
        double horiz = info.settings.gauge.scale() * 1.1;
        if (Config.ConfigDebug.oldNarrowWidth && info.settings.gauge.value() < 1.0) {
            horiz /= 2.0;
        }
        if (info.settings.isGradeCrossing) {
            horiz += 2.0 * info.settings.gauge.scale();
        }
        double clamp = 0.17 * info.settings.gauge.scale();
        float heightOffset = (float)(info.placementInfo.placementPosition.field_72448_b % 1.0);
        List<PosStep> path = this.getPath(0.25);
        PosStep start = path.get(0);
        PosStep end = path.get(path.size() - 1);
        Vec3d placeOff = new Vec3d(Math.abs(info.placementInfo.placementPosition.field_72450_a % 1.0) - 0.5, 0.0, Math.abs(info.placementInfo.placementPosition.field_72449_c % 1.0) - 0.5).func_186678_a(-1.0);
        int mainX = (int)Math.round(path.get((int)(path.size() / 2)).field_72450_a + placeOff.field_72450_a);
        int mainZ = (int)Math.round(path.get((int)(path.size() / 2)).field_72449_c + placeOff.field_72449_c);
        int flexDist = (int)Math.max(1.0, 3.0 * (0.5 + info.settings.gauge.scale() / 2.0));
        for (PosStep cur : path) {
            PosStep gagPos = cur;
            boolean isFlex = gagPos.func_72438_d(start) < (double)flexDist || gagPos.func_72438_d(end) < (double)flexDist;
            gagPos = gagPos.func_72441_c(0.0, heightOffset, 0.0);
            for (double q = -horiz; q <= horiz; q += 0.1) {
                Pair gag;
                Vec3d nextUp = VecUtil.fromYaw(q, 90.0f + cur.yaw);
                int posX = (int)Math.round(gagPos.field_72450_a + nextUp.field_72450_a + placeOff.field_72450_a);
                int posZ = (int)Math.round(gagPos.field_72449_c + nextUp.field_72449_c + placeOff.field_72449_c);
                double height = 0.0;
                if (info.settings.isGradeCrossing) {
                    height = (1.0 - (double)Math.abs((int)q) / horiz) / 3.0 - 0.05;
                    height *= info.settings.gauge.scale();
                    height = Math.min(height, clamp);
                }
                double relHeight = gagPos.field_72448_b % 1.0;
                if (gagPos.field_72448_b < 0.0) {
                    relHeight += 1.0;
                }
                if (!this.positions.contains(gag = Pair.of((Object)posX, (Object)posZ))) {
                    this.positions.add((Pair<Integer, Integer>)gag);
                    bedHeights.put(gag, Float.valueOf((float)(height + Math.max(0.0, relHeight - 0.1))));
                    railHeights.put(gag, Float.valueOf((float)relHeight));
                    yOffset.put(gag, (int)(gagPos.field_72448_b - relHeight));
                }
                if (!isFlex && !(Math.abs(q) > info.settings.gauge.value())) continue;
                flexPositions.add(gag);
            }
            if (isFlex || !endOfTrack) continue;
            mainX = (int)Math.round(gagPos.field_72450_a + placeOff.field_72450_a);
            mainZ = (int)Math.round(gagPos.field_72449_c + placeOff.field_72449_c);
        }
        BlockPos mainPos = new BlockPos(mainX, ((Integer)yOffset.get(Pair.of((Object)mainX, (Object)mainZ))).intValue(), mainZ);
        this.setParentPos(mainPos);
        TrackRail main = new TrackRail(this, mainPos);
        this.tracks.add(main);
        main.setRailHeight(((Float)railHeights.get(Pair.of((Object)mainX, (Object)mainZ))).floatValue());
        main.setBedHeight(((Float)bedHeights.get(Pair.of((Object)mainX, (Object)mainZ))).floatValue());
        for (Pair<Integer, Integer> pair : this.positions) {
            if ((Integer)pair.getLeft() == mainX && (Integer)pair.getRight() == mainZ) continue;
            TrackGag tg = new TrackGag(this, new BlockPos(((Integer)pair.getLeft()).intValue(), ((Integer)yOffset.get(pair)).intValue(), ((Integer)pair.getRight()).intValue()));
            if (flexPositions.contains(pair)) {
                tg.setFlexible();
            }
            tg.setRailHeight(((Float)railHeights.get(pair)).floatValue());
            tg.setBedHeight(((Float)bedHeights.get(pair)).floatValue());
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    private static float delta(float a, float b) {
        float angle = (float)Math.toDegrees(Math.toRadians(a) - Math.toRadians(b));
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        PosStep cur;
        int i;
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        double scale = this.info.settings.gauge.scale();
        List<PosStep> points = this.getPath(scale);
        boolean switchStraight = this.info.switchState == SwitchState.STRAIGHT;
        int switchSize = 0;
        TrackDirection direction = this.info.placementInfo.direction;
        if (switchStraight) {
            for (i = 0; i < points.size(); ++i) {
                cur = points.get(i);
                Vec3d flatPos = VecUtil.rotateYaw(cur, -this.info.placementInfo.yaw);
                if (!(Math.abs(flatPos.field_72449_c) >= 0.5 * scale)) continue;
                switchSize = i;
                break;
            }
        }
        for (i = 0; i < points.size(); ++i) {
            PosStep next;
            float angle;
            double switchOffset;
            PosStep switchPos = cur = points.get(i);
            if (switchStraight && (switchOffset = 1.0 - (double)i / (double)switchSize) > 0.0) {
                double dist = 0.2 * switchOffset * scale;
                Vec3d offset = VecUtil.fromYaw(dist, cur.yaw + 90.0f + this.info.placementInfo.direction.toYaw());
                double offsetAngle = Math.toDegrees(0.2 / (double)switchSize);
                if (direction == TrackDirection.RIGHT) {
                    offsetAngle = -offsetAngle;
                }
                switchPos = new PosStep(cur.func_178787_e(offset), cur.yaw + (float)offsetAngle, cur.pitch);
            }
            if (points.size() == 1) {
                angle = 0.0f;
            } else if (i + 1 == points.size()) {
                next = points.get(i - 1);
                angle = BuilderIterator.delta(next.yaw, cur.yaw);
                angle *= 2.0f;
            } else if (i == 0) {
                next = points.get(i + 1);
                angle = BuilderIterator.delta(cur.yaw, next.yaw);
                angle *= 2.0f;
            } else {
                PosStep prev = points.get(i - 1);
                PosStep next2 = points.get(i + 1);
                angle = BuilderIterator.delta(prev.yaw, next2.yaw);
            }
            if (angle != 0.0f) {
                if (direction == TrackDirection.RIGHT) {
                    data.add((BuilderBase)this.new BuilderBase.VecYawPitch(switchPos.field_72450_a, switchPos.field_72448_b, switchPos.field_72449_c, switchPos.yaw, switchPos.pitch, (1.0f - angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_LEFT"));
                    data.add((BuilderBase)this.new BuilderBase.VecYawPitch(cur.field_72450_a, cur.field_72448_b, cur.field_72449_c, cur.yaw, cur.pitch, (1.0f + angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_RIGHT"));
                } else {
                    data.add((BuilderBase)this.new BuilderBase.VecYawPitch(cur.field_72450_a, cur.field_72448_b, cur.field_72449_c, cur.yaw, cur.pitch, (1.0f - angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_LEFT"));
                    data.add((BuilderBase)this.new BuilderBase.VecYawPitch(switchPos.field_72450_a, switchPos.field_72448_b, switchPos.field_72449_c, switchPos.yaw, switchPos.pitch, (1.0f + angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_RIGHT"));
                }
                data.add((BuilderBase)this.new BuilderBase.VecYawPitch(cur.field_72450_a, cur.field_72448_b, cur.field_72449_c, cur.yaw, cur.pitch, "RAIL_BASE"));
                continue;
            }
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(cur.field_72450_a, cur.field_72448_b, cur.field_72449_c, cur.yaw, cur.pitch, new String[0]));
        }
        return data;
    }
}

