/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public abstract class BuilderBase {
    protected ArrayList<TrackBase> tracks = new ArrayList();
    public RailInfo info;
    public final BlockPos pos;
    private BlockPos parent_pos;
    public boolean overrideFlexible = true;
    public List<ItemStack> drops;

    public BuilderBase(RailInfo info, BlockPos pos) {
        this.info = info;
        this.pos = pos;
        this.parent_pos = pos;
    }

    public abstract List<VecYawPitch> getRenderData();

    public BlockPos convertRelativePositions(BlockPos rel) {
        return this.pos.func_177971_a((Vec3i)rel);
    }

    public boolean canBuild() {
        for (TrackBase track : this.tracks) {
            if (track.canPlaceTrack()) continue;
            return false;
        }
        return true;
    }

    public void build() {
        for (TrackBase track : this.tracks) {
            if (!track.isOverTileRail()) {
                track.placeTrack(true).func_70296_d();
                continue;
            }
            TileRail rail = TileRail.get((IBlockAccess)this.info.world, track.getPos());
            rail.setReplaced(track.placeTrack(false).serializeNBT());
            rail.func_70296_d();
        }
    }

    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    public void setParentPos(BlockPos pos) {
        this.parent_pos = this.convertRelativePositions(pos);
    }

    public BlockPos getParentPos() {
        return this.parent_pos;
    }

    public int costTies() {
        return MathHelper.func_76143_f((double)((double)(this.tracks.size() / 3) * Config.ConfigBalance.TieCostMultiplier));
    }

    public int costRails() {
        return MathHelper.func_76143_f((double)((double)(this.tracks.size() * 2 / 3) * Config.ConfigBalance.RailCostMultiplier));
    }

    public int costBed() {
        return MathHelper.func_76143_f((double)((double)this.tracks.size() * 0.1 * Config.ConfigBalance.BedCostMultiplier));
    }

    public int costFill() {
        int fillCount = 0;
        for (TrackBase track : this.tracks) {
            if (!BlockUtil.canBeReplaced(this.info.world, track.getPos().func_177977_b(), false)) continue;
            ++fillCount;
        }
        return MathHelper.func_76123_f((float)(this.info.settings.railBedFill.func_77973_b() != Items.field_190931_a ? (float)fillCount : 0.0f));
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public void clearArea() {
        for (TrackBase track : this.tracks) {
            int i = 0;
            while ((double)i < 6.0 * this.info.settings.gauge.scale()) {
                BlockPos main = track.getPos().func_177981_b(i);
                if (!BlockUtil.isRail(this.info.world, main)) {
                    this.info.world.func_175655_b(main, false);
                }
                if (this.info.settings.gauge.isModel() && Config.ConfigDamage.enableSideBlockClearing && this.info.settings.type != TrackItems.SLOPE && this.info.settings.type != TrackItems.TURNTABLE) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos pos = main.func_177972_a(facing);
                        if (BlockUtil.isRail(this.info.world, pos)) continue;
                        this.info.world.func_175655_b(pos, false);
                    }
                }
                ++i;
            }
            if (!BlockUtil.canBeReplaced(this.info.world, track.getPos().func_177977_b(), false)) continue;
            this.info.world.func_175655_b(track.getPos().func_177977_b(), false);
        }
    }

    public class VecYawPitch
    extends Vec3d {
        public final float yaw;
        public final float pitch;
        public final float length;
        public final List<String> groups;

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, String ... groups) {
            this(xIn, yIn, zIn, yaw, 0.0f, groups);
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, String ... groups) {
            this(xIn, yIn, zIn, yaw, pitch, -1.0f, groups);
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, float length, String ... groups) {
            super(xIn, yIn, zIn);
            this.yaw = yaw;
            this.groups = Arrays.asList(groups);
            this.pitch = pitch;
            this.length = length;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getLength() {
            return this.length;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

