/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.net.PreviewRenderPacket;
import cam72cam.immersiverailroading.proxy.ChunkManager;
import cam72cam.immersiverailroading.tile.SyncdTileEntity;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRailPreview
extends SyncdTileEntity
implements ITickable {
    private int ticksAlive;
    private RailInfo info;
    private ItemStack item;
    private PlacementInfo placementInfo;
    private PlacementInfo customInfo;

    public static TileRailPreview get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileRailPreview ? (TileRailPreview)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setup(ItemStack stack, PlacementInfo info) {
        this.item = stack.func_77946_l();
        this.placementInfo = info;
        this.func_70296_d();
    }

    public void setItem(ItemStack stack) {
        this.item = stack.func_77946_l();
        this.func_70296_d();
    }

    public void setCustomInfo(PlacementInfo info) {
        this.customInfo = info;
        if (this.customInfo != null) {
            RailSettings settings = ItemTrackBlueprint.settings(this.item);
            double lx = Math.abs(this.customInfo.placementPosition.field_72450_a - this.placementInfo.placementPosition.field_72450_a);
            double lz = Math.abs(this.customInfo.placementPosition.field_72449_c - this.placementInfo.placementPosition.field_72449_c);
            switch (settings.type) {
                case TURN: {
                    double length = (lx + lz) / 2.0 + 1.0;
                    settings = settings.withLength((int)Math.round(length *= 4.0 / (double)settings.quarters));
                    break;
                }
                case STRAIGHT: 
                case SLOPE: {
                    double length = Math.max(lx, lz) + 1.0;
                    settings = settings.withLength((int)Math.round(length));
                }
            }
            ItemTrackBlueprint.settings(this.item, settings);
        }
        this.func_70296_d();
    }

    public void setPlacementInfo(PlacementInfo info) {
        this.placementInfo = info;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.item = new ItemStack(nbt.func_74775_l("item"));
        this.placementInfo = new PlacementInfo(nbt.func_74775_l("placementInfo"));
        if (nbt.func_74764_b("customInfo")) {
            this.customInfo = new PlacementInfo(nbt.func_74775_l("customInfo"));
        }
        this.info = new RailInfo(this.field_145850_b, this.item, this.placementInfo, this.customInfo);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)this.item.serializeNBT());
        nbt.func_74782_a("placementInfo", (NBTBase)this.placementInfo.toNBT());
        if (this.customInfo != null) {
            nbt.func_74782_a("customInfo", (NBTBase)this.customInfo.toNBT());
        }
        return super.func_189515_b(nbt);
    }

    public RailInfo getRailRenderInfo() {
        if (this.func_145830_o() && this.info.world == null) {
            this.info = new RailInfo(this.field_145850_b, this.item, this.placementInfo, this.customInfo);
        }
        return this.info;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.info = new RailInfo(this.field_145850_b, this.item, this.placementInfo, this.customInfo);
        if (this.isMulti()) {
            ImmersiveRailroading.net.sendToAll((IMessage)new PreviewRenderPacket(this));
        }
    }

    public boolean isMulti() {
        if (this.info.getBuilder() instanceof IIterableTrack) {
            return ((IIterableTrack)((Object)this.info.getBuilder())).getSubBuilders() != null;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isMulti()) {
            ChunkManager.flagEntityPos(this.field_145850_b, this.field_174879_c);
            if (this.ticksAlive % 20 == 0) {
                ImmersiveRailroading.net.sendToAll((IMessage)new PreviewRenderPacket(this));
            }
            ++this.ticksAlive;
        }
    }
}

