/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.CouplerAugmentMode;
import cam72cam.immersiverailroading.library.LocoControlMode;
import cam72cam.immersiverailroading.library.StockDetectorMode;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.tile.SyncdTileEntity;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.ParticleUtil;
import cam72cam.immersiverailroading.util.RedstoneUtil;
import cam72cam.immersiverailroading.util.SwitchUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import trackapi.lib.ITrack;

public class TileRailBase
extends SyncdTileEntity
implements ITrack,
ITickable {
    private BlockPos parent;
    private float bedHeight = 0.0f;
    private float railHeight = 0.0f;
    private Augment augment;
    private String augmentFilterID;
    private int snowLayers = 0;
    protected boolean flexible = false;
    private boolean willBeReplaced = false;
    private NBTTagCompound replaced;
    private boolean skipNextRefresh = false;
    public ItemStack railBedCache = null;
    private FluidTank augmentTank = null;
    private int redstoneLevel = 0;
    private StockDetectorMode redstoneMode = StockDetectorMode.SIMPLE;
    private LocoControlMode controlMode = LocoControlMode.THROTTLE_FORWARD;
    private CouplerAugmentMode couplerMode = CouplerAugmentMode.ENGAGED;
    private int clientLastTankAmount = 0;
    private long clientSoundTimeout = 0L;
    private int ticksExisted;
    public boolean blockUpdate;

    public static TileRailBase get(IBlockAccess world, BlockPos pos) {
        SyncdTileEntity te = SyncdTileEntity.get(world, pos, Chunk.EnumCreateEntityType.IMMEDIATE);
        return te instanceof TileRailBase ? (TileRailBase)te : null;
    }

    @Override
    public boolean isLoaded() {
        return !this.field_145850_b.field_72995_K || this.hasTileData;
    }

    public void setBedHeight(float height) {
        this.bedHeight = height;
    }

    public float getBedHeight() {
        if (this.replaced != null && this.replaced.func_74764_b("height")) {
            float replacedHeight = this.replaced.func_74760_g("height");
            return Math.min(this.bedHeight, replacedHeight);
        }
        return this.bedHeight;
    }

    public double getRenderGauge() {
        double gauge = 0.0;
        TileRail parent = this.getParentTile();
        if (parent != null) {
            gauge = parent.info.settings.gauge.value();
        }
        if (this.getParentReplaced() != null && (parent = TileRail.get((IBlockAccess)this.field_145850_b, this.getParentReplaced())) != null) {
            gauge = Math.min(gauge, parent.info.settings.gauge.value());
        }
        return gauge;
    }

    public void setRailHeight(float height) {
        this.railHeight = height;
    }

    public float getRailHeight() {
        return this.railHeight;
    }

    public void setAugment(Augment augment) {
        this.augment = augment;
        this.setAugmentFilter(null);
        this.func_70296_d();
    }

    public boolean setAugmentFilter(String definitionID) {
        this.augmentFilterID = definitionID != this.augmentFilterID ? definitionID : null;
        this.func_70296_d();
        return this.augmentFilterID != null;
    }

    public String nextAugmentRedstoneMode() {
        if (this.augment == null) {
            return null;
        }
        switch (this.augment) {
            case DETECTOR: {
                this.redstoneMode = StockDetectorMode.values()[(this.redstoneMode.ordinal() + 1) % StockDetectorMode.values().length];
                return this.redstoneMode.toString();
            }
            case LOCO_CONTROL: {
                this.controlMode = LocoControlMode.values()[(this.controlMode.ordinal() + 1) % LocoControlMode.values().length];
                return this.controlMode.toString();
            }
            case COUPLER: {
                this.couplerMode = CouplerAugmentMode.values()[(this.couplerMode.ordinal() + 1) % CouplerAugmentMode.values().length];
                return this.couplerMode.toString();
            }
        }
        return null;
    }

    public Augment getAugment() {
        return this.augment;
    }

    public int getSnowLayers() {
        return this.snowLayers;
    }

    public void setSnowLayers(int snowLayers) {
        this.snowLayers = snowLayers;
        this.func_70296_d();
    }

    public float getFullHeight() {
        return this.bedHeight + (float)this.snowLayers / 8.0f;
    }

    public boolean handleSnowTick() {
        if (this.snowLayers < (Config.ConfigDebug.deepSnow ? 8 : 1)) {
            ++this.snowLayers;
            this.func_70296_d();
            return true;
        }
        return !Config.ConfigDebug.deepSnow;
    }

    public BlockPos getParent() {
        if (this.parent == null) {
            if (this.ticksExisted > 1 && !this.field_145850_b.field_72995_K) {
                ImmersiveRailroading.warn("Invalid block without parent", new Object[0]);
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
            return null;
        }
        return this.parent.func_177971_a((Vec3i)this.field_174879_c);
    }

    public void setParent(BlockPos pos) {
        this.parent = pos.func_177973_b((Vec3i)this.field_174879_c);
    }

    public boolean isFlexible() {
        return this.flexible || !(this instanceof TileRail);
    }

    public ItemStack getRenderRailBed() {
        TileRail pt;
        if (this.railBedCache == null && (pt = this.getParentTile()) != null) {
            this.railBedCache = pt.info.settings.railBed;
        }
        return this.railBedCache;
    }

    @Override
    public void writeUpdateNBT(NBTTagCompound nbt) {
        if (this.getRenderRailBed() != null) {
            nbt.func_74782_a("renderBed", (NBTBase)this.getRenderRailBed().serializeNBT());
        }
    }

    @Override
    public void readUpdateNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("renderBed")) {
            this.railBedCache = new ItemStack(nbt.func_74775_l("renderBed"));
        }
        if (this.augmentTank != null && this.augment == Augment.WATER_TROUGH) {
            int delta = this.clientLastTankAmount - this.augmentTank.getFluidAmount();
            if (delta > 0) {
                for (int i = 0; i < delta / 10; ++i) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        ParticleUtil.spawnParticle(this.field_145850_b, EnumParticleTypes.WATER_SPLASH, new Vec3d((Vec3i)this.field_174879_c.func_177972_a(facing)).func_72441_c(0.5, 0.5, 0.5));
                    }
                }
                if (this.clientSoundTimeout < this.field_145850_b.func_72820_D()) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.clientSoundTimeout = this.field_145850_b.func_72820_D() + 10L;
                }
            }
            this.clientLastTankAmount = this.augmentTank.getFluidAmount();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int version = 0;
        if (nbt.func_74764_b("version")) {
            version = nbt.func_74762_e("version");
        }
        this.railHeight = this.bedHeight = nbt.func_74760_g("height");
        this.snowLayers = nbt.func_74762_e("snowLayers");
        this.flexible = nbt.func_74767_n("flexible");
        if (nbt.func_74764_b("replaced")) {
            this.replaced = nbt.func_74775_l("replaced");
        }
        if (nbt.func_74764_b("augment")) {
            this.augment = Augment.values()[nbt.func_74762_e("augment")];
        }
        this.parent = BlockPos.func_177969_a((long)nbt.func_74763_f("parent"));
        switch (version) {
            case 0: 
            case 1: {
                this.parent = this.parent.func_177973_b((Vec3i)this.field_174879_c);
            }
        }
        if (nbt.func_74764_b("augmentTank")) {
            this.createAugmentTank();
            this.augmentTank.readFromNBT(nbt.func_74775_l("augmentTank"));
        }
        if (nbt.func_74764_b("augmentFilterID")) {
            this.augmentFilterID = nbt.func_74779_i("augmentFilterID");
        }
        if (nbt.func_74764_b("redstoneMode")) {
            this.redstoneMode = StockDetectorMode.values()[nbt.func_74762_e("redstoneMode")];
        }
        if (nbt.func_74764_b("controlMode")) {
            this.controlMode = LocoControlMode.values()[nbt.func_74762_e("controlMode")];
        }
        if (nbt.func_74764_b("couplerMode")) {
            this.couplerMode = CouplerAugmentMode.values()[nbt.func_74762_e("couplerMode")];
        }
        if (nbt.func_74764_b("railHeight")) {
            this.railHeight = nbt.func_74760_g("railHeight");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("parent", this.parent.func_177986_g());
        nbt.func_74776_a("height", this.bedHeight);
        nbt.func_74776_a("railHeight", this.railHeight);
        nbt.func_74768_a("snowLayers", this.snowLayers);
        nbt.func_74757_a("flexible", this.flexible);
        if (this.replaced != null) {
            nbt.func_74782_a("replaced", (NBTBase)this.replaced);
        }
        if (this.augment != null) {
            nbt.func_74768_a("augment", this.augment.ordinal());
            if (this.augmentTank != null) {
                nbt.func_74782_a("augmentTank", (NBTBase)this.augmentTank.writeToNBT(new NBTTagCompound()));
            }
            if (this.augmentFilterID != null) {
                nbt.func_74778_a("augmentFilterID", this.augmentFilterID);
            }
        }
        nbt.func_74768_a("redstoneMode", this.redstoneMode.ordinal());
        nbt.func_74768_a("controlMode", this.controlMode.ordinal());
        nbt.func_74768_a("couplerMode", this.couplerMode.ordinal());
        nbt.func_74768_a("version", 3);
        return super.func_189515_b(nbt);
    }

    public TileRail getParentTile() {
        if (this.getParent() == null) {
            return null;
        }
        TileRail te = TileRail.get((IBlockAccess)this.field_145850_b, this.getParent());
        if (te == null || !te.isLoaded()) {
            return null;
        }
        return te;
    }

    public void setReplaced(NBTTagCompound replaced) {
        this.replaced = replaced;
    }

    public NBTTagCompound getReplaced() {
        return this.replaced;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (this.skipNextRefresh) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void setWillBeReplaced(boolean value) {
        this.willBeReplaced = value;
    }

    public boolean getWillBeReplaced() {
        return this.willBeReplaced;
    }

    public void cleanSnow() {
        int snow = this.getSnowLayers();
        if (snow > 1) {
            this.setSnowLayers(1);
            int snowDown = snow - 1;
            for (int i = 1; i <= 3; ++i) {
                Object[] horiz = (EnumFacing[])EnumFacing.field_176754_o.clone();
                if (Math.random() > 0.5) {
                    ArrayUtils.reverse((Object[])horiz);
                }
                for (Object facing : horiz) {
                    BlockPos ph = this.field_145850_b.func_175725_q(this.field_174879_c.func_177967_a((EnumFacing)facing, i));
                    for (int j = 0; j < 3; ++j) {
                        IBlockState state = this.field_145850_b.func_180495_p(ph);
                        if (this.field_145850_b.func_175623_d(ph) && !BlockUtil.isRail(this.field_145850_b, ph.func_177977_b())) {
                            this.field_145850_b.func_175656_a(ph, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(snowDown)));
                            return;
                        }
                        if (this.field_145850_b.func_180495_p(ph).func_177230_c() == Blocks.field_150433_aE) {
                            ph = ph.func_177984_a();
                            continue;
                        }
                        if (this.field_145850_b.func_180495_p(ph).func_177230_c() == Blocks.field_150431_aC) {
                            Integer currSnow = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                            if (currSnow == 8) {
                                ph = ph.func_177984_a();
                                continue;
                            }
                            int toAdd = Math.min(8 - currSnow, snowDown);
                            this.field_145850_b.func_175656_a(ph, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(currSnow + toAdd)));
                            if ((snowDown -= toAdd) <= 0) {
                                return;
                            }
                        }
                        ph = ph.func_177977_b();
                    }
                }
            }
        }
    }

    public double getTrackGauge() {
        TileRail parent = this.getParentTile();
        if (parent != null) {
            return parent.info.settings.gauge.value();
        }
        return 0.0;
    }

    public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
        Vec3d potential;
        TileRail self;
        TileRail tileRail = self = this instanceof TileRail ? (TileRail)this : this.getParentTile();
        if (self == null) {
            return currentPosition;
        }
        SwitchState state = SwitchUtil.getSwitchState(self, currentPosition);
        TileRail tile = state == SwitchState.STRAIGHT ? self.getParentTile() : self;
        if (tile == null) {
            return currentPosition;
        }
        double distanceMeters = motion.func_72433_c();
        float rotationYaw = VecUtil.toWrongYaw(motion);
        Vec3d nextPos = MovementTrack.nextPosition(this.field_145850_b, currentPosition, tile, rotationYaw, distanceMeters);
        if (state != SwitchState.NONE && nextPos.func_72438_d(currentPosition) > Math.abs(distanceMeters) * 2.0 && (tile = self.getParentTile()) != null && (potential = MovementTrack.nextPosition(this.field_145850_b, currentPosition, tile, rotationYaw, distanceMeters)).func_72438_d(currentPosition.func_178787_e(motion)) < nextPos.func_72438_d(currentPosition.func_178787_e(motion))) {
            nextPos = potential;
        }
        if (new BlockPos(currentPosition).equals((Object)this.func_174877_v())) {
            TileRailBase target = this;
            while (target != null) {
                Vec3d potential2;
                boolean isSameTrack;
                TileRail parent = target.getParentTile();
                if (parent != null && parent.getParentTile() != null && tile.getParentTile() != null && !(isSameTrack = parent.getParentTile().func_174877_v().equals((Object)tile.getParentTile().func_174877_v())) && (potential2 = parent.getNextPosition(currentPosition, motion)).func_72438_d(currentPosition.func_178787_e(motion)) < nextPos.func_72438_d(currentPosition.func_178787_e(motion))) {
                    nextPos = potential2;
                }
                NBTTagCompound data = target.getReplaced();
                target = null;
                if (data == null) continue;
                target = new TileRailBase();
                target.func_145839_a(data);
                target.func_145834_a(this.field_145850_b);
            }
        }
        return nextPos;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case WATER_TROUGH: {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }
                case DETECTOR: 
                case LOCO_CONTROL: 
                case COUPLER: 
                case SPEED_RETARDER: {
                    break;
                }
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T extends EntityRollingStock> T getStockNearBy(Class<T> type, Capability<?> capability) {
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177968_d().func_177976_e(), this.field_174879_c.func_177981_b(3).func_177974_f().func_177978_c());
        List stocks = this.field_145850_b.func_72872_a(type, bb);
        for (EntityRollingStock stock : stocks) {
            if (capability != null && !stock.hasCapability(capability, null) || this.augmentFilterID != null && !this.augmentFilterID.equals(stock.getDefinitionID())) continue;
            return (T)((Object)stock);
        }
        return null;
    }

    public EntityMoveableRollingStock getStockNearBy(Capability<?> capability) {
        return this.getStockNearBy(EntityMoveableRollingStock.class, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case WATER_TROUGH: {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                        if (this.augmentTank == null) {
                            this.createAugmentTank();
                        }
                        return (T)this.augmentTank;
                    }
                }
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                        EntityMoveableRollingStock stock = this.getStockNearBy(capability);
                        if (stock != null) {
                            return (T)stock.getCapability(capability, null);
                        }
                        return (T)new ItemStackHandler(0);
                    }
                }
                case DETECTOR: 
                case LOCO_CONTROL: 
                case COUPLER: 
                case SPEED_RETARDER: {
                    break;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    private void balanceTanks() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileRailBase neighbor = TileRailBase.get((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(facing));
            if (neighbor == null || neighbor.augmentTank == null || neighbor.augmentTank.getFluidAmount() + 1 >= this.augmentTank.getFluidAmount()) continue;
            this.transferAllFluid((IFluidHandler)this.augmentTank, (IFluidHandler)neighbor.augmentTank, (this.augmentTank.getFluidAmount() - neighbor.augmentTank.getFluidAmount()) / 2);
            this.func_70296_d();
        }
    }

    private void createAugmentTank() {
        switch (this.augment) {
            case FLUID_LOADER: 
            case FLUID_UNLOADER: {
                this.augmentTank = new FluidTank(1000);
                break;
            }
            case WATER_TROUGH: {
                this.augmentTank = new FluidTank(FluidRegistry.WATER, 0, 1000){

                    protected void onContentsChanged() {
                        TileRailBase.this.balanceTanks();
                        TileRailBase.this.func_70296_d();
                    }
                };
                break;
            }
        }
    }

    public void transferAllFluid(IFluidHandler source, IFluidHandler dest, int maxQuantity) {
        FluidStack possibleDrain = source.drain(maxQuantity, false);
        if (possibleDrain == null || possibleDrain.amount == 0) {
            return;
        }
        int filled = dest.fill(possibleDrain, true);
        source.drain(filled, true);
    }

    public void transferAllItems(IItemHandler source, IItemHandler dest, int numstacks) {
        for (int slot = 0; slot < source.getSlots(); ++slot) {
            ItemStack stack = source.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            int orig_count = stack.func_190916_E();
            if ((stack = ItemHandlerHelper.insertItem((IItemHandler)dest, (ItemStack)stack, (boolean)false)).func_190916_E() != orig_count) {
                source.extractItem(slot, orig_count - stack.func_190916_E(), false);
                --numstacks;
            }
            if (numstacks > 0) continue;
            return;
        }
    }

    private <T> List<T> getCapsNearby(Capability<T> cap) {
        ArrayList<Object> found = new ArrayList<Object>();
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity nte;
            BlockPos npos = this.field_174879_c.func_177972_a(facing);
            if (this.field_145850_b.func_175623_d(npos) || BlockUtil.isIRRail(this.field_145850_b, npos) || (nte = this.field_145850_b.func_175625_s(npos)) == null || !nte.hasCapability(cap, facing.func_176734_d())) continue;
            found.add(nte.getCapability(cap, facing.func_176734_d()));
        }
        return found;
    }

    public void func_73660_a() {
        block48: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            ++this.ticksExisted;
            if (Config.ConfigDebug.snowMeltRate != 0 && this.snowLayers != 0 && (int)(Math.random() * (double)Config.ConfigDebug.snowMeltRate * 10.0) == 0 && !this.field_145850_b.func_72896_J()) {
                this.setSnowLayers(--this.snowLayers);
            }
            if (this.ticksExisted > 1 && (this.ticksExisted % 100 == 0 || this.blockUpdate)) {
                double floating;
                this.blockUpdate = false;
                if (this.getParent() == null || !this.field_145850_b.func_175667_e(this.getParent())) {
                    return;
                }
                if (this.getParentTile() == null) {
                    if (BlockRailBase.tryBreakRail((IBlockAccess)this.field_145850_b, this.field_174879_c)) {
                        this.func_145831_w().func_175655_b(this.field_174879_c, true);
                    }
                    return;
                }
                if (Config.ConfigDamage.requireSolidBlocks && this instanceof TileRail && (floating = ((TileRail)this).percentFloating()) > Config.ConfigBalance.trackFloatingPercent) {
                    if (BlockRailBase.tryBreakRail((IBlockAccess)this.field_145850_b, this.field_174879_c)) {
                        this.func_145831_w().func_175655_b(this.field_174879_c, true);
                    }
                    return;
                }
            }
            if (this.augment == null) {
                return;
            }
            Capability fluid_cap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
            Capability item_cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            try {
                block1 : switch (this.augment) {
                    case ITEM_LOADER: {
                        EntityMoveableRollingStock stock = this.getStockNearBy(item_cap);
                        if (stock == null) break;
                        IItemHandler stock_items = (IItemHandler)stock.getCapability(item_cap, null);
                        for (IItemHandler neighbor : this.getCapsNearby(item_cap)) {
                            this.transferAllItems(neighbor, stock_items, 1);
                        }
                        break;
                    }
                    case ITEM_UNLOADER: {
                        EntityMoveableRollingStock stock = this.getStockNearBy(item_cap);
                        if (stock == null) break;
                        IItemHandler stock_items = (IItemHandler)stock.getCapability(item_cap, null);
                        for (IItemHandler neighbor : this.getCapsNearby(item_cap)) {
                            this.transferAllItems(stock_items, neighbor, 1);
                        }
                        break;
                    }
                    case FLUID_LOADER: {
                        EntityMoveableRollingStock stock;
                        if (this.augmentTank == null) {
                            this.createAugmentTank();
                        }
                        if ((stock = this.getStockNearBy(fluid_cap)) == null) break;
                        IFluidHandler stock_fluid = (IFluidHandler)stock.getCapability(fluid_cap, null);
                        this.transferAllFluid((IFluidHandler)this.augmentTank, stock_fluid, 100);
                        for (IFluidHandler neighbor : this.getCapsNearby(fluid_cap)) {
                            this.transferAllFluid(neighbor, stock_fluid, 100);
                        }
                        break;
                    }
                    case FLUID_UNLOADER: {
                        EntityMoveableRollingStock stock;
                        if (this.augmentTank == null) {
                            this.createAugmentTank();
                        }
                        if ((stock = this.getStockNearBy(fluid_cap)) == null) break;
                        IFluidHandler stock_fluid = (IFluidHandler)stock.getCapability(fluid_cap, null);
                        this.transferAllFluid(stock_fluid, (IFluidHandler)this.augmentTank, 100);
                        for (IFluidHandler neighbor : this.getCapsNearby(fluid_cap)) {
                            this.transferAllFluid(stock_fluid, neighbor, 100);
                        }
                        break;
                    }
                    case WATER_TROUGH: {
                        Tender tender;
                        if (this.augmentTank == null) {
                            this.createAugmentTank();
                        }
                        if ((tender = this.getStockNearBy(Tender.class, fluid_cap)) != null) {
                            this.transferAllFluid((IFluidHandler)this.augmentTank, (IFluidHandler)tender.getCapability(fluid_cap, null), TileRailBase.waterPressureFromSpeed(tender.getCurrentSpeed().metric()));
                            break;
                        }
                        if (this.ticksExisted % 20 != 0) break;
                        this.balanceTanks();
                        break;
                    }
                    case LOCO_CONTROL: {
                        Locomotive loco = this.getStockNearBy(Locomotive.class, null);
                        if (loco == null) break;
                        int power = RedstoneUtil.getPower(this.field_145850_b, this.field_174879_c);
                        switch (this.controlMode) {
                            case THROTTLE_FORWARD: {
                                loco.setThrottle((float)power / 15.0f);
                                break block1;
                            }
                            case THROTTLE_REVERSE: {
                                loco.setThrottle((float)(-power) / 15.0f);
                                break block1;
                            }
                            case BRAKE: {
                                loco.setAirBrake((float)power / 15.0f);
                                break block1;
                            }
                            case HORN: {
                                loco.setHorn(40, null);
                                break block1;
                            }
                        }
                        break;
                    }
                    case DETECTOR: {
                        EntityMoveableRollingStock stock = this.getStockNearBy(null);
                        int currentRedstone = this.redstoneLevel;
                        int newRedstone = 0;
                        switch (this.redstoneMode) {
                            case SIMPLE: {
                                newRedstone = stock != null ? 15 : 0;
                                break;
                            }
                            case SPEED: {
                                newRedstone = stock != null ? (int)Math.floor(Math.abs(stock.getCurrentSpeed().metric()) / 10.0) : 0;
                                break;
                            }
                            case PASSENGERS: {
                                newRedstone = stock != null ? Math.min(15, stock.func_184188_bt().size() + stock.staticPassengers.size()) : 0;
                                break;
                            }
                            case CARGO: {
                                if (stock == null || !(stock instanceof Freight)) break;
                                newRedstone = stock != null ? ((Freight)stock).getPercentCargoFull() * 15 / 100 : 0;
                                break;
                            }
                            case LIQUID: {
                                if (stock == null || !(stock instanceof FreightTank)) break;
                                int n = newRedstone = stock != null ? ((FreightTank)stock).getPercentLiquidFull() * 15 / 100 : 0;
                            }
                        }
                        if (newRedstone == currentRedstone) break;
                        this.redstoneLevel = newRedstone;
                        this.func_70296_d();
                        break;
                    }
                    case COUPLER: {
                        EntityMoveableRollingStock stock = this.getStockNearBy(null);
                        int power = RedstoneUtil.getPower(this.field_145850_b, this.field_174879_c);
                        if (stock == null || !(stock instanceof EntityCoupleableRollingStock) || power <= 0) break;
                        EntityCoupleableRollingStock couplable = (EntityCoupleableRollingStock)stock;
                        switch (this.couplerMode) {
                            case ENGAGED: {
                                for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                                    couplable.setCouplerEngaged(coupler, true);
                                }
                                break block48;
                            }
                            case DISENGAGED: {
                                for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                                    couplable.setCouplerEngaged(coupler, false);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching(ex);
            }
        }
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public double getTankLevel() {
        return this.augmentTank == null ? 0.0 : (double)this.augmentTank.getFluidAmount() / (double)this.augmentTank.getCapacity();
    }

    private static int waterPressureFromSpeed(double speed) {
        if (speed < 0.0) {
            return 0;
        }
        return (int)(speed * speed / 200.0);
    }

    public BlockPos getParentReplaced() {
        if (this.replaced == null) {
            return null;
        }
        if (!this.replaced.func_74764_b("parent")) {
            return null;
        }
        return BlockPos.func_177969_a((long)this.replaced.func_74763_f("parent")).func_177971_a((Vec3i)this.field_174879_c);
    }
}

