/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty.opencomputers;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.physics.PhysicsAccummulator;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.tile.TileRailBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AugmentDriver
implements DriverBlock {
    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
        if (te == null) {
            return null;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return null;
        }
        switch (augment) {
            case DETECTOR: {
                return new DetectorAugment(world, pos);
            }
            case LOCO_CONTROL: {
                return new LocoControlAugment(world, pos);
            }
        }
        return null;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing facing) {
        TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return false;
        }
        switch (augment) {
            case DETECTOR: 
            case LOCO_CONTROL: {
                return true;
            }
        }
        return false;
    }

    public class LocoControlAugment
    extends AugmentManagerBase {
        public LocoControlAugment(World world, BlockPos pos) {
            super(world, pos);
            this.typeFilter = Locomotive.class;
        }

        public String preferredName() {
            return "ir_augment_control";
        }

        @Callback(doc="function(double) -- sets the locomotive throttle")
        public Object[] setThrottle(Context context, Arguments arguments) throws Exception {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            Locomotive stock = te.getStockNearBy(Locomotive.class, null);
            if (stock != null) {
                stock.setThrottle(this.normalize(arguments.checkDouble(0)));
            }
            return null;
        }

        private float normalize(double val) {
            if (Double.isNaN(val)) {
                return 0.0f;
            }
            if (val > 1.0) {
                return 1.0f;
            }
            if (val < -1.0) {
                return -1.0f;
            }
            return (float)val;
        }

        @Callback(doc="function(double) -- sets the locomotive brake")
        public Object[] setBrake(Context context, Arguments arguments) throws Exception {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            Locomotive stock = te.getStockNearBy(Locomotive.class, null);
            if (stock != null) {
                stock.setAirBrake(this.normalize(arguments.checkDouble(0)));
            }
            return null;
        }

        @Callback(doc="function() -- fires the locomotive horn")
        public Object[] horn(Context context, Arguments arguments) throws Exception {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            Locomotive stock = te.getStockNearBy(Locomotive.class, null);
            if (stock != null) {
                stock.setHorn(arguments.optInteger(0, 40), null);
            }
            return null;
        }

        @Callback(doc="function():string -- returns the current augment type")
        public Object[] getAugmentType(Context context, Arguments args) {
            Augment augment = TileRailBase.get((IBlockAccess)this.world, this.pos).getAugment();
            if (augment != null) {
                return new Object[]{augment.toString()};
            }
            return null;
        }

        @Callback(doc="function():array -- returns the position of the augment")
        public Object[] getPos(Context context, Arguments args) {
            return new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()};
        }
    }

    public class DetectorAugment
    extends AugmentManagerBase {
        public DetectorAugment(World world, BlockPos pos) {
            super(world, pos);
        }

        public String preferredName() {
            return "ir_augment_detector";
        }

        private FluidStack getFluid() {
            Capability capability;
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityMoveableRollingStock stock = te.getStockNearBy(capability = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (stock != null) {
                IFluidHandler fh = (IFluidHandler)stock.getCapability(capability, null);
                return fh.drain(Integer.MAX_VALUE, false);
            }
            return null;
        }

        public void loco_info(Locomotive car, Map<String, Object> info) {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityMoveableRollingStock stock = te.getStockNearBy(null);
            LocomotiveDefinition def = car.getDefinition();
            info.put("id", def.defID);
            info.put("name", def.name());
            info.put("tag", car.tag);
            EnumFacing dir = EnumFacing.func_176733_a((double)car.field_70177_z);
            if (car.getCurrentSpeed().metric() < 0.0) {
                dir = dir.func_176734_d();
            }
            info.put("direction", dir.toString());
            info.put("passengers", car.func_184188_bt().size() + stock.staticPassengers.size());
            info.put("speed", car.getCurrentSpeed().metric());
            info.put("weight", car.getWeight());
            LocomotiveDefinition locoDef = car.getDefinition();
            info.put("horsepower", locoDef.getHorsePower(car.gauge));
            info.put("traction", locoDef.getStartingTractionNewtons(car.gauge));
            info.put("max_speed", locoDef.getMaxSpeed(car.gauge).metric());
            info.put("brake", Float.valueOf(car.getAirBrake()));
            info.put("throttle", Float.valueOf(car.getThrottle()));
            if (car instanceof LocomotiveSteam) {
                LocomotiveSteam steam = (LocomotiveSteam)car;
                info.put("pressure", Float.valueOf(steam.getBoilerPressure()));
                info.put("temperature", Float.valueOf(steam.getBoilerTemperature()));
            }
            if (car instanceof LocomotiveDiesel) {
                info.put("temperature", Float.valueOf(((LocomotiveDiesel)car).getEngineTemperature()));
            }
        }

        @Callback(doc="function():table -- returns an info dump about the current car")
        public Object[] info(Context context, Arguments arguments) {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityMoveableRollingStock stock = te.getStockNearBy(null);
            if (stock != null) {
                FluidStack fluid;
                HashMap<String, Object> info = new HashMap<String, Object>();
                EntityRollingStockDefinition def = stock.getDefinition();
                info.put("id", def.defID);
                info.put("name", def.name());
                info.put("tag", stock.tag);
                EnumFacing dir = EnumFacing.func_176733_a((double)stock.field_70177_z);
                if (stock.getCurrentSpeed().metric() < 0.0) {
                    dir = dir.func_176734_d();
                }
                info.put("direction", dir.toString());
                info.put("passengers", stock.func_184188_bt().size() + stock.staticPassengers.size());
                info.put("speed", stock.getCurrentSpeed().metric());
                info.put("weight", stock.getWeight());
                if (stock instanceof Locomotive) {
                    this.loco_info((Locomotive)stock, info);
                }
                if ((fluid = this.getFluid()) != null) {
                    info.put("fluid_type", fluid.getFluid().getName());
                    info.put("fluid_amount", fluid.amount);
                } else {
                    info.put("fluid_type", null);
                    info.put("fluid_amount", 0);
                }
                if (stock instanceof FreightTank) {
                    info.put("fluid_max", ((FreightTank)stock).getTankCapacity().MilliBuckets());
                }
                if (stock instanceof Freight) {
                    Freight freight = (Freight)stock;
                    info.put("cargo_percent", freight.getPercentCargoFull());
                    info.put("cargo_size", freight.getInventorySize());
                }
                return new Object[]{info};
            }
            return null;
        }

        @Callback(doc="function():table -- returns an info dump about the current consist")
        public Object[] consist(Context context, Arguments arguments) {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityCoupleableRollingStock stock = te.getStockNearBy(EntityCoupleableRollingStock.class, null);
            if (stock != null) {
                int traction = 0;
                PhysicsAccummulator acc = new PhysicsAccummulator(stock.getCurrentTickPosAndPrune());
                stock.mapTrain(stock, true, true, acc::accumulate);
                HashMap<String, Object> info = new HashMap<String, Object>();
                ArrayList<HashMap<String, Object>> locos = new ArrayList<HashMap<String, Object>>();
                info.put("cars", acc.count);
                info.put("tractive_effort_N", acc.tractiveEffortNewtons);
                info.put("weight_kg", acc.massToMoveKg);
                info.put("speed_km", stock.getCurrentSpeed().metric());
                EnumFacing dir = EnumFacing.func_176733_a((double)stock.field_70177_z);
                if (stock.getCurrentSpeed().metric() < 0.0) {
                    dir = dir.func_176734_d();
                }
                info.put("direction", dir.toString());
                for (EntityCoupleableRollingStock car : stock.getTrain()) {
                    if (!(car instanceof Locomotive)) continue;
                    LocomotiveDefinition locoDef = ((Locomotive)car).getDefinition();
                    traction += locoDef.getStartingTractionNewtons(car.gauge);
                    HashMap<String, Object> sub_info = new HashMap<String, Object>();
                    this.loco_info((Locomotive)car, sub_info);
                    locos.add(sub_info);
                }
                info.put("locomotives", locos);
                info.put("totoal_traction_N", traction);
                return new Object[]{info};
            }
            return null;
        }

        @Callback(doc="function():table -- gets the stock's tag")
        public Object[] getTag(Context context, Arguments arguments) {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityMoveableRollingStock stock = te.getStockNearBy(null);
            if (stock != null) {
                return new Object[]{stock.tag};
            }
            return null;
        }

        @Callback(doc="function():table -- sets the stock's tag")
        public Object[] setTag(Context context, Arguments arguments) {
            TileRailBase te = TileRailBase.get((IBlockAccess)this.world, this.pos);
            EntityMoveableRollingStock stock = te.getStockNearBy(null);
            if (stock != null) {
                stock.tag = arguments.checkString(0);
            }
            return null;
        }

        @Callback(doc="function():string -- returns the current augment type")
        public Object[] getAugmentType(Context context, Arguments args) {
            Augment augment = TileRailBase.get((IBlockAccess)this.world, this.pos).getAugment();
            if (augment != null) {
                return new Object[]{augment.toString()};
            }
            return null;
        }

        @Callback(doc="function():array -- returns the position of the augment")
        public Object[] getPos(Context context, Arguments args) {
            return new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()};
        }
    }

    public abstract class AugmentManagerBase
    extends AbstractManagedEnvironment
    implements NamedBlock {
        protected final World world;
        protected final BlockPos pos;
        private int ticksAlive;
        private UUID wasOverhead;
        protected Class<? extends EntityRollingStock> typeFilter = EntityRollingStock.class;

        public AugmentManagerBase(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.preferredName(), Visibility.Network).create());
        }

        public boolean canUpdate() {
            return true;
        }

        public void update() {
            EntityRollingStock nearby;
            TileRailBase te;
            Node node = this.node();
            if (this.ticksAlive == 0) {
                te = TileRailBase.get((IBlockAccess)this.world, this.pos);
                nearby = te.getStockNearBy(this.typeFilter, null);
                UUID uUID = this.wasOverhead = nearby != null ? nearby.getPersistentID() : null;
            }
            if (node != null && this.ticksAlive % Math.max(Config.ConfigDebug.ocPollDelayTicks, 1) == 0) {
                UUID isOverhead;
                te = TileRailBase.get((IBlockAccess)this.world, this.pos);
                nearby = te.getStockNearBy(this.typeFilter, null);
                UUID uUID = isOverhead = nearby != null ? nearby.getPersistentID() : null;
                if (isOverhead != this.wasOverhead) {
                    Node neighbor = (Node)node.neighbors().iterator().next();
                    neighbor.sendToReachable("computer.signal", new Object[]{"ir_train_overhead", te.getAugment().toString(), isOverhead == null ? null : isOverhead.toString()});
                }
                this.wasOverhead = isOverhead;
            }
            ++this.ticksAlive;
        }

        public int priority() {
            return 3;
        }
    }
}

