/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.sound;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.sound.ClientSound;
import cam72cam.immersiverailroading.sound.ISound;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import org.apache.commons.lang3.tuple.Pair;
import paulscode.sound.SoundSystem;

public class IRSoundManager {
    private SoundManager manager;
    private Function<ResourceLocation, URL> getURLForSoundResource;
    private Supplier<SoundSystem> soundSystem;
    private List<ISound> sounds = new ArrayList<ISound>();
    private float lastSoundLevel;
    private SoundCategory category = SoundCategory.AMBIENT;
    private SoundSystem cachedSnd;

    public IRSoundManager(SoundManager manager) {
        this.manager = manager;
        this.initSoundSystem(Pair.of((Object)"field_148620_e", (Object)"func_148612_a"), Pair.of((Object)"sndSystem", (Object)"getURLForSoundResource"));
        this.lastSoundLevel = Minecraft.func_71410_x().field_71474_y.func_186711_a(this.category);
    }

    @SafeVarargs
    private final void initSoundSystem(Pair<String, String> ... fieldNames) {
        for (Pair<String, String> fieldName : fieldNames) {
            try {
                Method getURLField = SoundManager.class.getDeclaredMethod((String)fieldName.getRight(), ResourceLocation.class);
                getURLField.setAccessible(true);
                this.getURLForSoundResource = loc -> {
                    try {
                        return (URL)getURLField.invoke(null, loc);
                    }
                    catch (Exception e) {
                        ImmersiveRailroading.catching(e);
                        return null;
                    }
                };
            }
            catch (Exception e) {
                ImmersiveRailroading.catching(e);
                continue;
            }
            try {
                Field sndSystemField = SoundManager.class.getDeclaredField((String)fieldName.getLeft());
                sndSystemField.setAccessible(true);
                this.soundSystem = () -> {
                    try {
                        if (this.cachedSnd == null) {
                            this.cachedSnd = (SoundSystem)sndSystemField.get(this.manager);
                        }
                        return this.cachedSnd;
                    }
                    catch (Exception e) {
                        ImmersiveRailroading.catching(e);
                        return null;
                    }
                };
                return;
            }
            catch (Exception e) {
                ImmersiveRailroading.catching(e);
            }
        }
    }

    public ISound createSound(ResourceLocation oggLocation, boolean repeats, float attenuationDistance, Gauge gauge) {
        SoundSystem sndSystem = this.soundSystem.get();
        if (sndSystem == null) {
            return null;
        }
        ClientSound snd = new ClientSound(this.soundSystem, oggLocation, this.getURLForSoundResource.apply(oggLocation), this.lastSoundLevel, repeats, attenuationDistance, gauge);
        this.sounds.add(snd);
        return snd;
    }

    public void tick() {
        float newSoundLevel = Minecraft.func_71410_x().field_71474_y.func_186711_a(this.category);
        if (newSoundLevel != this.lastSoundLevel) {
            this.lastSoundLevel = newSoundLevel;
            for (ISound sound : this.sounds) {
                sound.updateBaseSoundLevel(this.lastSoundLevel);
            }
        }
        if (ImmersiveRailroading.proxy.getTicks() % 20 == 0) {
            ArrayList<ISound> toRemove = new ArrayList<ISound>();
            for (ISound sound : this.sounds) {
                if (!sound.isDisposable() || sound.isPlaying()) continue;
                toRemove.add(sound);
            }
            for (ISound sound : toRemove) {
                this.sounds.remove(sound);
                sound.stop();
                sound.terminate();
            }
        }
    }

    public boolean hasSounds() {
        return this.sounds.size() != 0;
    }

    public void stop() {
        for (ISound sound : this.sounds) {
            sound.stop();
            sound.terminate();
        }
        this.sounds = new ArrayList<ISound>();
    }

    public void handleReload(boolean soft) {
        if (soft) {
            for (ISound sound : this.sounds) {
                sound.stop();
            }
        }
        this.cachedSnd = null;
        for (ISound sound : this.sounds) {
            sound.reload();
        }
    }
}

