/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class RailBuilderRender {
    private static OBJRender baseRailModel;
    private static OBJRender baseRailModelModel;
    private static DisplayListCache displayLists;

    public static OBJRender getModel(Gauge gauge) {
        return gauge.isModel() ? baseRailModel : baseRailModelModel;
    }

    public static void renderRailBuilder(RailInfo info) {
        OBJRender model = info.settings.gauge.isModel() ? baseRailModel : baseRailModelModel;
        Integer displayList = (Integer)displayLists.get(info.uniqueID);
        if (displayList == null) {
            if (!ClientProxy.renderCacheLimiter.canRender()) {
                return;
            }
            displayList = ClientProxy.renderCacheLimiter.newList(() -> {
                for (BuilderBase.VecYawPitch piece : info.getBuilder().getRenderData()) {
                    Matrix4 m = new Matrix4();
                    m.translate(piece.field_72450_a, piece.field_72448_b, piece.field_72449_c);
                    m.rotate(Math.toRadians(piece.getYaw()), 0.0, 1.0, 0.0);
                    m.rotate(Math.toRadians(piece.getPitch()), 1.0, 0.0, 0.0);
                    m.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                    if (piece.getLength() != -1.0f) {
                        m.scale((double)piece.getLength() / info.settings.gauge.scale(), 1.0, 1.0);
                    }
                    double scale = info.settings.gauge.scale();
                    m.scale(scale, scale, scale);
                    if (piece.getGroups().size() != 0) {
                        ArrayList<String> groups = new ArrayList<String>();
                        for (String baseGroup : piece.getGroups()) {
                            for (String groupName : model.model.groups()) {
                                if (!groupName.contains(baseGroup)) continue;
                                groups.add(groupName);
                            }
                        }
                        model.drawDirectGroups(groups, 1.0, m);
                        continue;
                    }
                    model.drawDirectGroups(model.model.groups.keySet(), 1.0, m);
                }
            });
            displayLists.put(info.uniqueID, displayList);
        }
        model.bindTexture();
        Minecraft.func_71410_x().field_71424_I.func_76320_a("dl");
        GL11.glCallList((int)displayList);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        model.restoreTexture();
    }

    static {
        try {
            baseRailModel = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading", "models/block/track_1m.obj"), 0.05f));
        }
        catch (Exception e) {
            ImmersiveRailroading.catching(e);
        }
        try {
            baseRailModelModel = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading", "models/block/track_1m_model.obj"), 0.05f));
        }
        catch (Exception e) {
            ImmersiveRailroading.catching(e);
        }
        displayLists = new DisplayListCache();
    }
}

