/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.render.rail.RailBaseRender;
import cam72cam.immersiverailroading.render.rail.RailBuilderRender;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class TrackBlueprintItemModel
implements IBakedModel {
    private RailInfo info;

    public TrackBlueprintItemModel() {
    }

    public TrackBlueprintItemModel(ItemStack stack, World world) {
        if (world == null) {
            world = Minecraft.func_71410_x().field_71441_e;
        }
        this.info = new RailInfo(world, stack, new PlacementInfo(stack, 1.0f, new BlockPos(0, 0, 0), 0.5f, 0.5f, 0.5f), null);
        this.info = this.info.withLength(10);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.info == null) {
            return new ArrayList<BakedQuad>();
        }
        GL11.glPushMatrix();
        if (this.info.settings.type == TrackItems.TURN || this.info.settings.type == TrackItems.SWITCH) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-0.1 * (double)this.info.settings.quarters));
        }
        GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
        double scale = 0.95 / (double)this.info.settings.length;
        if (this.info.settings.type == TrackItems.CROSSING) {
            scale = 0.31666666666666665;
        }
        if (this.info.settings.type == TrackItems.TURNTABLE) {
            scale *= 0.25;
        }
        GL11.glScaled((double)(-scale), (double)(-scale * 2.0), (double)scale);
        GLBoolTracker cull = new GLBoolTracker(2884, false);
        GLBoolTracker lighting = new GLBoolTracker(2896, false);
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
        RailBaseRender.draw(this.info);
        GL11.glPopMatrix();
        RailBuilderRender.renderRailBuilder(this.info);
        lighting.restore();
        cull.restore();
        GL11.glPopMatrix();
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideListHack();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair defaultVal = ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType);
        switch (cameraTransformType) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-60.0), 0.0, 0.0, 1.0).translate(0.5, 0.25, 0.5).toMatrix4f());
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-30.0), 0.0, 0.0, 1.0).translate(0.5, 0.25, 0.5).toMatrix4f());
            }
            case GROUND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.0, 0.5).toMatrix4f());
            }
            case FIXED: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case GUI: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.0, 0.0).rotate(Math.toRadians(95.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case HEAD: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.0, 0.0, 0.5).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case NONE: {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public class ItemOverrideListHack
    extends ItemOverrideList {
        public ItemOverrideListHack() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return new TrackBlueprintItemModel(stack, world);
        }
    }
}

